#!/bin/sh

package=raintpl

echo "attempting to get a newer version of ${package}"

if uscan; then
    version=$(uscan --report --verbose| sed -n 's/Newest version on remote site is \([.0-9]\+\).*/\1/p')
    if [ -f ../${package}_${version}.orig.tar.gz ]; then
	cd ..
	tar xzf ${package}_${version}.orig.tar.gz && \
	    mv raintpl-v.${version} raintpl-${version}
	echo "extracted the newest version into ../raintpl-${version}"
    fi
else
    echo "no new version: end of $0."
fi
