% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{initial_cache}
\alias{initial_cache}
\alias{get_cache}
\alias{rm_cache}
\alias{initial_cache_item}
\alias{get_cache_item}
\alias{rm_cache_item}
\alias{update_cache_item}
\alias{get_cache_element}
\title{cache intermediate data}
\usage{
initial_cache()

get_cache()

rm_cache()

initial_cache_item(item)

get_cache_item(item)

rm_cache_item(item)

update_cache_item(item, elements)

get_cache_element(item, elements)
}
\arguments{
\item{item}{the name of the cached item}

\item{elements}{elements to be cached in the item}
}
\value{
return the cache environment, item or selected elements, depends on the functions.
}
\description{
Yulab provides a set of utilities to cache intermediate data,
including initialize the cached item, update cached item and rmove the cached item, etc.
}
\examples{
\dontrun{
 slow_fib <- function(x) {
     if (x < 2) return(1)
     slow_fib(x-2) + slow_fib(x-1)
 }
 
 fast_fib <- function(x) {
     if (x < 2) return(1)
     res <- get_cache_element('fibonacci', as.character(x))
     if (!is.null(res)) { 
         return(res)
     }
     res <- fast_fib(x-2) + fast_fib(x-1)
     e <- list()
     e[[as.character(x)]] <- res
     update_cache_item('fibonacci', e)
     return(res)
 }

 system.time(slow_fib(30))
 system.time(fast_fib(30)) 
    
 }
}
