% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml_name.R
\name{xml_name}
\alias{xml_name}
\alias{xml_name<-}
\alias{xml_set_name}
\title{The (tag) name of an xml element.}
\usage{
xml_name(x, ns = character())

xml_name(x, ns = character()) <- value

xml_set_name(x, value, ns = character())
}
\arguments{
\item{x}{A document, node, or node set.}

\item{ns}{Optionally, a named vector giving prefix-url pairs, as produced
by \code{\link[=xml_ns]{xml_ns()}}. If provided, all names will be explicitly
qualified with the ns prefix, i.e. if the element \code{bar} is defined
in namespace \code{foo}, it will be called \code{foo:bar}. (And
similarly for attributes). Default namespaces must be given an explicit
name. The ns is ignored when using \code{\link[=xml_name<-]{xml_name<-()}} and
\code{\link[=xml_set_name]{xml_set_name()}}.}

\item{value}{a character vector with replacement name.}
}
\value{
A character vector.
}
\description{
The (tag) name of an xml element.

Modify the (tag) name of an element
}
\examples{
x <- read_xml("<bar>123</bar>")
xml_name(x)

y <- read_xml("<bar><baz>1</baz>abc<foo /></bar>")
z <- xml_children(y)
xml_name(xml_children(y))
}
