% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string.R
\name{join_words}
\alias{join_words}
\title{Join multiple words into a single string}
\usage{
join_words(
  words,
  sep = ", ",
  and = " and ",
  before = "",
  after = before,
  oxford_comma = TRUE
)
}
\arguments{
\item{words}{A character vector.}

\item{sep}{Separator to be inserted between words.}

\item{and}{Character string to be prepended to the last word.}

\item{before, after}{A character string to be added before/after each word.}

\item{oxford_comma}{Whether to insert the separator between the last two
elements in the list.}
}
\value{
A character string marked by \code{\link[=raw_string]{raw_string()}}.
}
\description{
If \code{words} is of length 2, the first word and second word are joined by the
\code{and} string; if \code{and} is blank, \code{sep} is used. When the length is greater
than 2, \code{sep} is used to separate all words, and the \code{and} string is
prepended to the last word.
}
\examples{
join_words("a")
join_words(c("a", "b"))
join_words(c("a", "b", "c"))
join_words(c("a", "b", "c"), sep = " / ", and = "")
join_words(c("a", "b", "c"), and = "")
join_words(c("a", "b", "c"), before = "\"", after = "\"")
join_words(c("a", "b", "c"), before = "\"", after = "\"", oxford_comma = FALSE)
}
