% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dwt.R
\name{phase.shift}
\alias{phase.shift}
\alias{phase.shift.packet}
\title{Phase Shift Wavelet Coefficients}
\usage{
phase.shift(z, wf, inv = FALSE)

phase.shift.packet(z, wf, inv = FALSE)
}
\arguments{
\item{z}{DWT object}

\item{wf}{character string; wavelet filter used in DWT}

\item{inv}{Boolean variable; if \code{inv=TRUE} then the inverse phase shift
is applied}
}
\value{
DWT (DWPT) object with coefficients circularly shifted.
}
\description{
Wavelet coefficients are circularly shifted by the amount of phase shift
induced by the wavelet transform.
}
\details{
The center-of-energy argument of Hess-Nielsen and Wickerhauser (1996) is
used to provide a flexible way to circularly shift wavelet coefficients
regardless of the wavelet filter used.  The results are not identical to
those used by Percival and Walden (2000), but are more flexible.

\code{phase.shift.packet} is not yet implemented fully.
}
\references{
Hess-Nielsen, N. and M. V. Wickerhauser (1996) Wavelets and
time-frequency analysis, \emph{Proceedings of the IEEE}, \bold{84}, No. 4,
523-540.

Percival, D. B. and A. T. Walden (2000) \emph{Wavelet Methods for Time
Series Analysis}, Cambridge University Press.
}
\author{
B. Whitcher
}
\keyword{ts}
