\name{denoise.2d}
\alias{denoise.dwt.2d}
\alias{denoise.modwt.2d}
\title{Denoise an Image via the 2D Discrete Wavelet Transform}
\description{
  Perform simple de-noising of an image using the two-dimensional
  discrete wavelet transform.
}
\usage{
denoise.dwt.2d(x, wf = "la8", J = 4, method = "universal", H = 0.5, 
               noise.dir = 3, rule = "hard")
denoise.modwt.2d(x, wf = "la8", J = 4, method = "universal", H = 0.5, 
                 rule = "hard") 
}
\arguments{
  \item{x}{input matrix (image)}
  \item{wf}{name of the wavelet filter to use in the decomposition}
  \item{J}{depth of the decomposition, must be a number less than or
    equal to \eqn{\log_2(\min\{M,N\})}{log(min{M,N},2)}}
  \item{method}{character string describing the threshold applied, only
    \code{"universal"} and \code{"long-memory"} are currently
    implemented}
  \item{H}{self-similarity or Hurst parameter to indicate spectral
    scaling, white noise is 0.5}
  \item{noise.dir}{number of directions to estimate background noise
    standard deviation, the default is 3 which produces a unique
    estimate of the background noise for each spatial direction}
  \item{rule}{either a \code{"hard"} or \code{"soft"} thresholding rule
    may be used}
}
\value{
  Image of the same dimension as the original but with high-freqency
  fluctuations removed.
}
\details{
  See \code{\link{Thresholding}}.
}
\references{
  See \code{\link{Thresholding}} for references concerning de-noising in
  one dimension.
}
\seealso{\code{\link{Thresholding}}}
\examples{
## Xbox image
data(xbox)
n <- NROW(xbox)
xbox.noise <- xbox + matrix(rnorm(n*n, sd=.15), n, n)
par(mfrow=c(2,2), cex=.8, pty="s")
image(xbox.noise, col=rainbow(128), main="Original Image")
image(denoise.dwt.2d(xbox.noise, wf="haar"), col=rainbow(128),
      zlim=range(xbox.noise), main="Denoised image")
image(xbox.noise - denoise.dwt.2d(xbox.noise, wf="haar"), col=rainbow(128),
      zlim=range(xbox.noise), main="Residual image")

## Daubechies image
data(dau)
n <- NROW(dau)
dau.noise <- dau + matrix(rnorm(n*n, sd=10), n, n)
par(mfrow=c(2,2), cex=.8, pty="s")
image(dau.noise, col=rainbow(128), main="Original Image")
dau.denoise <- denoise.modwt.2d(dau.noise, wf="d4", rule="soft")
image(dau.denoise, col=rainbow(128), zlim=range(dau.noise),
      main="Denoised image")
image(dau.noise - dau.denoise, col=rainbow(128), main="Residual image")
}
\author{B. Whitcher}
\keyword{ts}
