% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNR.R
\name{SNR}
\alias{SNR}
\title{Signal to Noise Ratio}
\usage{
SNR(HLC, n, ...)
}
\arguments{
\item{HLC}{Object that is coercible to xts or matrix and contains
High-Low-Close prices.}

\item{n}{Number of periods for moving average.}

\item{...}{Other arguments to be passed to \code{\link{ATR}}.}
}
\value{
A object of the same class as HLC or a matrix (if try.xts fails)
containing the signal to noise ratio.
}
\description{
The n-day SNR for a given market is calculated by taking the absolute
price change over an n-day period and dividing it by the average
n-day volatility.
}
\details{
\deqn{SNR_n = \frac{|C_t - C_{t-n}|}{ATR_n}
}{SNR = abs(Cl - lag(Cl,n)) / ATR(HLC, n)$atr}

Using average true range as the volatility measure captures more of the
intraday and overnight volatility in a way that a measurement of
Close-to-Close price change does not.

The interpretation is then relatively intuitive: an SNR value of five
indicates that the market has moved five times the volatility (average true
range) over the given look-back period.
}
\references{
Skeggs, James and Hill, Alex (2015). Back in Black Part 2: The
Opportunity Set for Trend Following.
}
\author{
Peter Carl
}
