% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{multiDist}
\alias{multiDist}
\title{Metric function for \code{multiPhylo} input}
\usage{
multiDist(trees, lambda = 0, return.lambda.function = FALSE,
  save.memory = FALSE, emphasise.tips = NULL, emphasise.weight = 2)
}
\arguments{
\item{trees}{an object of the class \code{multiPhylo} containing the trees to be compared}

\item{lambda}{a number in [0,1] which specifies the extent to which topology (default, with lambda=0)  or branch lengths (lambda=1) are emphasised. This argument is ignored if \code{return.lambda.function=TRUE}.}

\item{return.lambda.function}{If true, a function that can be invoked with different lambda values is returned.
This function returns the matrix of metric values for the given lambda.}

\item{save.memory}{A flag that saves a lot of memory but increases the execution time (not compatible with return.lambda.function=TRUE).}

\item{emphasise.tips}{an optional list of tips whose entries in the tree vectors should be emphasised. Defaults to \code{NULL}.}

\item{emphasise.weight}{applicable only if a list is supplied to \code{emphasise.tips}, this value (default 2) is the number by which vector entries corresponding to those tips are emphasised.}
}
\value{
The pairwise tree distance matrix or a function that produces the distance matrix given a value for lambda.
}
\description{
Comparison of a list of trees using the Kendall Colijn metric. Output is given as a pairwise distance matrix. This is equivalent to the \code{$D} output from \code{treespace} but may be preferable for large datasets, and when principal co-ordinate analysis is not required. It includes an option to save memory at the expense of computation time.
}
\examples{

## generate 10 random trees, each with 6 tips
trees <- rmtree(10,6)

## pairwise distance matrix when lambda=0
multiDist(trees)

## pairwise distance matrix as a function of lambda:
m <- multiDist(trees, return.lambda.function=TRUE)

## evaluate at lambda=0. Equivalent to multiDist(trees).
m0 <- m(0)

## save memory by recomputing each tree vector for each pairwise tree comparison (for fixed lambda):
m0.5 <- multiDist(trees,0.5,save.memory=TRUE)


}
\author{
Jacob Almagro-Garcia \email{nativecoder@gmail.com}

Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}
