% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinytest.R
\name{exit_file}
\alias{exit_file}
\alias{exit_if_not}
\title{Stop testing (conditionally)}
\usage{
exit_file(msg = "")

exit_if_not(...)
}
\arguments{
\item{msg}{\code{[character]} An optional message to print after exiting.}

\item{...}{A comma-separated list of conditions.}
}
\value{
The exit message
}
\description{
Use \code{exit_file} to exit a file with a custom message, or use
\code{exit_if} to exit if one or more conditions are met. \code{exit_if}
will create a message akin to messages created by \code{\link[base]{stopifnot}}.
}
\examples{
exit_file("I'm too tired to test")
exit_if_not(packageVersion("tinytest")  >= "1.0.0")
\dontrun{
exit_if_not(requireNamespace("foo",quietly=TRUE))
}
}
\seealso{
Other test-files: 
\code{\link{build_install_test}()},
\code{\link{run_test_dir}()},
\code{\link{run_test_file}()},
\code{\link{summary.tinytests}()},
\code{\link{test_package}()}
}
\concept{test-files}
