% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-invisible.R
\name{expect_invisible}
\alias{expect_invisible}
\alias{expect_visible}
\title{Does code return a visible or invisible object?}
\usage{
expect_invisible(call, label = NULL)

expect_visible(call, label = NULL)
}
\arguments{
\item{call}{A function call.}

\item{label}{Used to customise failure messages. For expert use only.}
}
\value{
The evaluated \code{call}, invisibly.
}
\description{
Use this to test whether a function returns a visible or invisible
output. Typically you'll use this to check that functions called primarily
for their side-effects return their data argument invisibly.
}
\examples{
expect_invisible(x <- 10)
expect_visible(x)

# Typically you'll assign the result of the expectation so you can
# also check that the value is as you expect.
greet <- function(name) {
  message("Hi ", name)
  invisible(name)
}
out <- expect_invisible(greet("Hadley"))
expect_equal(out, "Hadley")
}
