% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pow_search.R
\name{pow_search}
\alias{pow_search}
\title{Search Kew's Plants of the World}
\usage{
pow_search(q, limit = 100, cursor = "*", sort = NULL, ...)
}
\arguments{
\item{q}{(character) query terms}

\item{limit}{(integer) Number of records to return. default: 100}

\item{cursor}{(character) cursor string}

\item{sort}{(character) The field to sort by and sort order separted with
underscore, e.g., \code{sort="name_desc"}}

\item{...}{Further args passed on to \link[crul:HttpClient]{crul::HttpClient}.}
}
\value{
a list with slots for metadata (\code{meta}) with list of response
attributes, and data (\code{data}) with a data.frame of results
}
\description{
Search Kew's Plants of the World
}
\examples{
\dontrun{
x <- pow_search(q = "Quercus")
x$meta
x$meta$totalResults
x$meta$perPage
x$meta$totalPages
x$meta$page
x$meta$cursor
head(x$data)

# pagination
pow_search(q = "sunflower", limit = 2)

# debug curl stuff
invisible(pow_search(q = "Helianthus annuus", verbose = TRUE))

# sort
desc <- pow_search(q = "Helianthus", sort = "name_desc")
desc$data$name
asc <- pow_search(q = "Helianthus", sort = "name_asc")
asc$data$name
}
}
\references{
\url{http://powo.science.kew.org/}
}
\seealso{
Other pow: 
\code{\link{get_pow}()},
\code{\link{pow_lookup}()}
}
\author{
Scott Chamberlain, \email{myrmecocystus@gmail.com}
}
\concept{pow}
