% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comm2sci.R
\name{comm2sci}
\alias{comm2sci}
\title{Get scientific names from common names.}
\usage{
comm2sci(commnames, db = "eol", itisby = "search", simplify = TRUE, ...)
}
\arguments{
\item{commnames}{One or more common names or partial names.}

\item{db}{Data source, one of \emph{"eol"} (default), \emph{"itis"},
\emph{"tropicos"}, \emph{"ncbi"}, or \emph{"worms"}.}

\item{itisby}{Search for common names across entire names (search, default),
at beginning of names (begin), or at end of names (end).}

\item{simplify}{(logical) If \code{TRUE}, simplify output to a vector
of names. If \code{FALSE}, return variable formats from different sources,
usually a data.frame.}

\item{...}{Further arguments passed on to internal methods.}
}
\value{
If \code{simplify=TRUE}, a list of scientific names, with list
labeled by your input names. If \code{simplify=FALSE}, a data.frame with
columns that vary by data source
}
\description{
Get scientific names from common names.
}
\details{
For data sources ITIS and NCBI you can pass in common names
directly, and use \code{\link[taxize]{get_uid}} or
\code{\link[taxize]{get_tsn}} to get ids first, then pass in to this fxn.

For the other data sources, you can only pass in common names directly.
}
\examples{
\dontrun{
comm2sci(commnames='black bear')
comm2sci(commnames='black bear', simplify = FALSE)
comm2sci(commnames='black bear', db='itis')
comm2sci(commnames='annual blue grass', db='tropicos')
comm2sci(commnames=c('annual blue grass','tree of heaven'), db='tropicos')
comm2sci(commnames=c('black bear', 'roe deer'))
comm2sci('blue whale', db = "worms")
comm2sci(c('blue whale', 'dwarf surfclam'), db = "worms")

# Output easily converts to a data.frame with plyr::ldply
library(plyr)
ldply(comm2sci(commnames=c('annual blue grass','tree of heaven'),
  db='tropicos'))

# ncbi: pass in uid's from get_uid() directly
x <- get_uid("western capercaillie", modifier = "Common Name")
comm2sci(x)
# itis: pass in tsn's from get_tsn() directly
x <- get_tsn(c("Louisiana black bear", "american crow"),
  searchtype = "common")
comm2sci(x)
}
}
\seealso{
\code{\link[taxize]{sci2comm}}
}
\author{
Scott Chamberlain
}
