% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/susie_utils.R
\name{get_cs_correlation}
\alias{get_cs_correlation}
\title{Get Correlations Between CSs, using Variable with Maximum PIP From Each CS}
\usage{
get_cs_correlation(model, X = NULL, Xcorr = NULL, max = FALSE)
}
\arguments{
\item{model}{A SuSiE fit, typically an output from
\code{\link{susie}} or one of its variants.}

\item{X}{n by p matrix of values of the p variables (covariates) in
n samples. When provided, correlation between variables will be
computed and used to remove CSs whose minimum correlation among
variables is smaller than \code{min_abs_corr}.}

\item{Xcorr}{p by p matrix of correlations between variables
(covariates). When provided, it will be used to remove CSs whose
minimum correlation among variables is smaller than
\code{min_abs_corr}.}

\item{max}{When \code{max = FAFLSE}, return a matrix of CS
correlations. When \code{max = TRUE}, return only the maximum
absolute correlation among all pairs of correlations.}
}
\value{
A matrix of correlations between CSs, or the maximum
  absolute correlation when \code{max = TRUE}.
}
\description{
This function evaluates the correlation between single effect
  CSs. It is not part of the SuSiE inference. Rather, it is designed as
  a diagnostic tool to assess how correlated the reported CS are.
}
