% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{N3finemapping}
\alias{N3finemapping}
\title{Simulated Fine-mapping Data with Three Effect Variables.}
\format{
\code{N3finemapping} is a list with the following elements:

\describe{

  \item{X}{N by P variable matrix of centered and scaled genotype
data.}

  \item{chrom}{Chromomsome of the original data, in hg38 coordinate.}

  \item{pos}{Chromomosomal positoin of the original data, in hg38
coordinate. The information can be used to compare impact of using
other genotype references of the same variables in susie_rss
application.}

  \item{true_coef}{The simulated effect sizes.}

  \item{residual_variance}{The simulated residual covariance matrix.}

  \item{Y}{The simulated response variables.}

  \item{allele_freq}{Allele frequency of the original genotype data.}

  \item{V}{Prior covariance matrix for effect size of the three
non-zero effect variables.}  }
}
\description{
The data-set contains a matrix of 574
individuals and 1,001 variables. These variables are real-world
genotypes centered and scaled, and therefore retains the
correlation structure of variables in the original genotype data. 3
out of the variables have non-zero effects.  The response data is
generated under a multivariate linear regression model. See Wang
\emph{et al} (2020) for more details.
}
\examples{
data(N3finemapping)
}
\references{
G. Wang, A. Sarkar, P. Carbonetto and M. Stephens (2020). A simple
  new approach to variable selection in regression, with application
  to genetic fine-mapping. \emph{Journal of the Royal Statistical
  Society, Series B} \doi{10.1101/501114}.
}
\keyword{data}
