% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_ggsurvplot.R
\name{add_ggsurvplot}
\alias{add_ggsurvplot}
\alias{+.ggsurv}
\alias{\%++\%}
\title{Add Components to a ggsurvplot}
\usage{
\method{+}{ggsurv}(e1, e2)

e1 \%++\% e2
}
\arguments{
\item{e1}{an object of class ggsurv.}

\item{e2}{a plot component such as theme and labs.}
}
\description{
Allows to add ggplot components - theme(), labs(), ... - to an
 object of class ggsurv, which is a list of ggplots.
}
\examples{
# Fit survival curves
require("survival")
fit<- survfit(Surv(time, status) ~ sex, data = lung)

# Basic survival curves
p <- ggsurvplot(fit, data = lung, risk.table = TRUE,
   main = "Survival curve",
   submain = "Based on Kaplan-Meier estimates",
   caption = "created with survminer"
   )
p

# Customizing the plots
p + theme_survminer(
     font.main = c(16, "bold", "darkblue"),
     font.submain = c(15, "bold.italic", "purple"),
     font.caption = c(14, "plain", "orange"),
     font.x = c(14, "bold.italic", "red"),
     font.y = c(14, "bold.italic", "darkred"),
     font.tickslab = c(12, "plain", "darkgreen")
)
}
\seealso{
\code{\link{theme_survminer}} and \code{\link{ggsurvplot}}
}
