% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_transliterate.R
\name{stri_trans_general}
\alias{stri_trans_general}
\title{General Text Transforms, Including Transliteration}
\usage{
stri_trans_general(str, id, rules = FALSE, forward = TRUE)
}
\arguments{
\item{str}{character vector}

\item{id}{a single string with transform identifier,
see \code{\link{stri_trans_list}}, or custom transliteration rules}

\item{rules}{if \code{TRUE}, treat \code{id} as a string with
semicolon-separated transliteration rules (see the \pkg{ICU} manual);}

\item{forward}{transliteration direction (\code{TRUE} for forward,
\code{FALSE} for reverse)}
}
\value{
Returns a character vector.
}
\description{
\pkg{ICU} General transforms provide different ways
for processing Unicode text. They are useful in handling a variety
of different tasks, including:
\itemize{
\item    locale-independent upper case, lower case, title case,
    full/halfwidth conversions,
\item    normalization,
\item    hex and character name conversions,
\item    script to script conversion/transliteration.
}
}
\details{
\pkg{ICU} Transforms were mainly designed to transliterate characters
from one script to another (for example, from Greek to Latin,
or Japanese Katakana to Latin).
However, these services are also capable of handling a much
broader range of tasks.
In particular, the Transforms include prebuilt transformations
for case conversions, for normalization conversions, for the removal
of given characters, and also for a variety of language and script
transliterations. Transforms can be chained together to perform
a series of operations and each step of the process can use a
UnicodeSet to restrict the characters that are affected.

To get the list of available transforms,
call \code{\link{stri_trans_list}}.

Note that transliterators are often combined in sequence
to achieve a desired transformation.
This is analogous to the composition of mathematical functions.
For example, given a script that converts lowercase ASCII characters
from Latin script to Katakana script, it is convenient to first
(1) separate input base characters and accents, and then (2)
convert uppercase to lowercase.
To achieve this, a compound transform can be specified as follows:
\code{NFKD; Lower; Latin-Katakana;} (with the default \code{rules=FALSE}).

Custom rule-based transliteration is also supported, see the \pkg{ICU}
manual and below for some examples.

Transliteration is not dependent on the current locale.
}
\examples{
stri_trans_general('gro\u00df', 'latin-ascii')
stri_trans_general('stringi', 'latin-greek')
stri_trans_general('stringi', 'latin-cyrillic')
stri_trans_general('stringi', 'upper') # see stri_trans_toupper
stri_trans_general('\u0104', 'nfd; lower') # compound id; see stri_trans_nfd
stri_trans_general('Marek G\u0105golewski', 'pl-pl_FONIPA')
stri_trans_general('\u2620', 'any-name') # character name
stri_trans_general('\\\\N{latin small letter a}', 'name-any') # decode name
stri_trans_general('\u2620', 'hex/c') # to hex
stri_trans_general("\u201C\u2026\u201D \u0105\u015B\u0107\u017C",
    "NFKD; NFC; [^\\\\p{L}] latin-ascii")

x <- "\uC885\uB85C\uAD6C \uC0AC\uC9C1\uB3D9"
stringi::stri_trans_general(x, "Hangul-Latin")
# Deviate from the ICU rules of romanisation of Korean,
# see https://en.wikipedia.org/wiki/Romanization_of_Korean
id <- "
    :: NFD;
    \u11A8 > k;
    \u11AE > t;
    \u11B8 > p;
    \u1105 > r;
    :: Hangul-Latin;
"
stringi::stri_trans_general(x, id, rules=TRUE)


}
\references{
\emph{General Transforms} -- ICU User Guide,
\url{https://unicode-org.github.io/icu/userguide/transforms/general/}
}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Gagolewski M., \pkg{stringi}: Fast and portable character string processing in R, \emph{Journal of Statistical Software} 103(2), 2022, 1-59, \doi{10.18637/jss.v103.i02}

Other transform: 
\code{\link{stri_trans_char}()},
\code{\link{stri_trans_list}()},
\code{\link{stri_trans_nfc}()},
\code{\link{stri_trans_tolower}()}
}
\concept{transform}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
