% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.utilities.R
\name{handle.controls}
\alias{handle.controls}
\title{Handle standard \verb{control.*()} function semantics.}
\usage{
handle.controls(myname, ...)
}
\arguments{
\item{myname}{the name of the calling function.}

\item{...}{the \code{...} argument of the control function, if present.}
}
\value{
a list with formal arguments of the calling function.
}
\description{
This function takes the arguments of its caller (whose name should
be passed explicitly), plus any \code{...} arguments and produces a
control list based on the standard semantics of \verb{control.*()}
functions, including handling deprecated arguments, identifying
undefined arguments, and handling arguments that should be passed
through \code{\link[=match.arg]{match.arg()}}.
}
\details{
The function behaves based on the information it acquires from the calling function. Specifically,
\itemize{
\item The values of formal arguments (except \code{...}, if present) are
taken from the environment of the calling function and stored in
the list.
\item If the calling function has a \code{...} argument \emph{and} defines an
\code{old.controls} variable in its environment, then it remaps the
names in \code{...} to their new names based on \code{old.controls}. In
addition, if the value is a list with two elements, \code{action} and
\code{message}, the standard deprecation message will have \code{message}
appended to it and then be called with \code{action()}.
\item If the calling function has a \code{match.arg.pars} in its
environment, the arguments in that list are processed through
\code{\link[=match.arg]{match.arg()}}.
}
}
