% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.utilities.R
\name{compress_rows.data.frame}
\alias{compress_rows.data.frame}
\alias{decompress_rows.compressed_rows_df}
\title{"Compress" a data frame.}
\usage{
\method{compress_rows}{data.frame}(x, ...)

\method{decompress_rows}{compressed_rows_df}(x, ...)
}
\arguments{
\item{x}{For \code{compress_rows.data.frame} a \code{\link{data.frame}} to be
compressed. For \code{decompress_rows.compress_rows_df} a \code{\link{list}} as
returned by \code{compress_rows.data.frame}.}

\item{...}{Additional arguments, currently unused.}
}
\value{
For \code{compress_rows.data.frame}, a \code{\link{list}} with three
elements: \item{rows }{Unique rows of \code{x}} \item{frequencies }{A vector
of the same length as the number or rows, giving the number of times the
corresponding row is repeated } \item{ordering}{A vector such that if
\code{c} is the compressed data frame, \code{c$rows[c$ordering,,drop=FALSE]}
equals the original data frame, except for row names} \item{rownames}{Row
names of \code{x}}

For \code{decompress_rows.compressed_rows_df}, the original data frame.
}
\description{
\code{compress_rows.data.frame} "compresses" a data frame, returning unique rows
and a tally of the number of times each row is repeated, as well as a
permutation vector that can reconstruct the original data frame.
\code{decompress_rows.compressed_rows_df} reconstructs the original data frame.
}
\examples{

(x <- data.frame(V1=sample.int(3,30,replace=TRUE),
                 V2=sample.int(2,30,replace=TRUE),
                 V3=sample.int(4,30,replace=TRUE)))

(c <- compress_rows(x))

stopifnot(all(decompress_rows(c)==x))

}
\seealso{
\code{\link{data.frame}}
}
\keyword{manip}
