% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_beta.R
\name{find_beta}
\alias{find_beta}
\alias{find_beta2}
\alias{find_cauchy}
\alias{find_normal}
\title{Determining distribution parameters}
\usage{
find_beta(x1, p1, x2, p2)

find_beta2(x, se, ci, n)

find_cauchy(x1, p1, x2, p2)

find_normal(x1, p1, x2, p2)
}
\arguments{
\item{x1}{Value for the first percentile.}

\item{p1}{Probability of the first percentile.}

\item{x2}{Value for the second percentile.}

\item{p2}{Probability of the second percentile.}

\item{x}{Numeric, a probability value between 0 and 1. Typically indicates
a prevalence rate of an outcome of interest; Or an integer value
with the number of observed events. In this case, specify \code{n}
to indicate the toral number of observations.}

\item{se}{The standard error of \code{x}. Either \code{se} or \code{ci} must
be specified.}

\item{ci}{The upper limit of the confidence interval of \code{x}. Either
\code{se} or \code{ci} must be specified.}

\item{n}{Numeric, number of total observations. Needs to be specified, if
\code{x} is an integer (number of observed events), and no
probability. See 'Examples'.}
}
\value{
A list of length two, with the two distribution parameters than can
        be used to define the distribution, which (best) describes
        the shape for the given input parameters.
}
\description{
\code{find_beta()}, \code{find_normal()} and \code{find_cauchy()} find the
             shape, mean and standard deviation resp. the location and scale parameters
             to describe the beta, normal or cauchy distribution, based on two
             percentiles. \code{find_beta2()} finds the shape parameters for a Beta
             distribution, based on a probability value and its standard error
             or confidence intervals.
}
\details{
These functions can be used to find parameter for various distributions,
         to define prior probabilities for Bayesian analyses. \code{x1},
         \code{p1}, \code{x2} and \code{p2} are parameters that describe two
         quantiles. Given this knowledge, the distribution parameters are
         returned. \cr \cr
         Use \code{find_beta2()}, if the known parameters are, e.g. a prevalence
         rate or similar probability, and its standard deviation or confidence
         interval. In this case. \code{x} should be a probability,
         for example a prevalence rate of a certain event. \code{se} then
         needs to be the standard error for this probability. Alternatively,
         \code{ci} can be specified, which should indicate the upper limit
         of the confidence interval od the probability (prevalence rate) \code{x}.
         If the number of events out of a total number of trials is known
         (e.g. 12 heads out of 30 coin tosses), \code{x} can also be the number
         of observed events, while \code{n} indicates the total amount of trials
         (in the above example, the function call would be: \code{find_beta2(x = 12, n = 30)}).
}
\examples{
# example from blogpost:
# https://www.johndcook.com/blog/2010/01/31/parameters-from-percentiles/
# 10\% of patients respond within 30 days of treatment
# and 80\% respond within 90 days of treatment
find_normal(x1 = 30, p1 = .1, x2 = 90, p2 = .8)
find_cauchy(x1 = 30, p1 = .1, x2 = 90, p2 = .8)

parms <- find_normal(x1 = 30, p1 = .1, x2 = 90, p2 = .8)
curve(
  dnorm(x, mean = parms$mean, sd = parms$sd),
  from = 0, to = 200
)

parms <- find_cauchy(x1 = 30, p1 = .1, x2 = 90, p2 = .8)
curve(
  dcauchy(x, location = parms$location, scale = parms$scale),
  from = 0, to = 200
)


find_beta2(x = .25, ci = .5)

shapes <- find_beta2(x = .25, ci = .5)
curve(dbeta(x, shapes[[1]], shapes[[2]]))

# find Beta distribution for 3 events out of 20 observations
find_beta2(x = 3, n = 20)

shapes <- find_beta2(x = 3, n = 20)
curve(dbeta(x, shapes[[1]], shapes[[2]]))

}
\references{
Cook JD. Determining distribution parameters from quantiles. 2010: Department of Biostatistics, Texas (\href{https://www.johndcook.com/quantiles_parameters.pdf}{PDF})
}
