% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sso-metadata.R
\name{shinystan-metadata}
\alias{shinystan-metadata}
\alias{sso_info}
\alias{model_code}
\alias{notes}
\alias{model_name}
\title{View or change metadata associated with a \code{shinystan} object}
\usage{
sso_info(sso)

model_code(sso, code = NULL)

notes(sso, note = NULL, replace = FALSE)

model_name(sso, name = NULL)
}
\arguments{
\item{sso}{A \code{\link[=as.shinystan]{shinystan object}}.}

\item{code}{A string, containing model code to be added, that can be
used as an argument to \code{\link{cat}}. See \strong{Examples}.}

\item{note}{A string containing a note to add to any existing notes
or replace existing notes, depending on the value of \code{replace}.}

\item{replace}{If \code{TRUE} the existing notes are overwritten by 
\code{note} if \code{note} is specified. If \code{FALSE} (the default) 
if \code{note} is specified then its content is appended to the existing
notes.}

\item{name}{A string giving the new model name to use.}
}
\value{
\code{sso_info} prints basic metadata including number of parameters, 
  chains, iterations, warmup iterations, etc. It does not return anything.

\code{model_code} returns or replaces model code stored in a 
  \code{shinystan} object. If \code{code} is \code{NULL} then any existing 
  model code stored in \code{sso} is returned as a character string. If 
  \code{code} is specified then an updated \code{shinystan} object is 
  returned with \code{code} added. For \code{shinystan} objects created from 
  stanfit (\pkg{rstan}) and stanreg (\pkg{rstanarm}) objects, model code is 
  automatically taken from that object and does not need to be added 
  manually. From within the 'ShinyStan' interface model code can be viewed on
  the \strong{Model Code} page.

\code{notes} returns, amends, or replaces notes stored in a
  \code{shinystan} object. If \code{note} is \code{NULL} then any existing
  notes stored in \code{sso} are returned as a character string. If
  \code{note} is specified then an updated \code{shinystan} object is
  returned with either \code{note} added to the previous notes (if
  \code{replace=FALSE}) or overwritten by \code{note} (if \code{replace =
  TRUE}). From within the 'ShinyStan' interface, notes are viewable on the
  \strong{Notepad} page.

\code{model_name} returns or replaces the model name associated with 
  a \code{shinystan} object. If \code{name} is \code{NULL} then the current
  model name is returned. If \code{name} is specified then \code{sso} is
  returned with an updated model name.
}
\description{
View or change metadata associated with a \code{shinystan} object
}
\examples{
# use eight_schools example object
sso <- eight_schools

################
### sso_info ###
################

sso_info(sso)

##################
### model_code ###
##################

# view model code in example shinystan object 'eight_schools'
cat(model_code(sso))

# change the model code in sso 
# some jags style code
my_code <- "
 model {
   for (i in 1:length(Y)) {
     Y[i] ~ dpois(lambda[i])
     log(lambda[i]) <- inprod(X[i,], theta[])
   }
   for (j in 1:J) {
     theta[j] ~ dt(0.0, 1.0, 1.0)
   }
 }
"
sso <- model_code(sso, my_code)
cat(model_code(sso))

#############
### notes ###
#############

# view existing notes
notes(sso)

# add a note to the existing notes
sso <- notes(sso, "New note")
notes(sso)
cat(notes(sso))

# replace existing notes
sso <- notes(sso, "replacement note", replace = TRUE)
notes(sso)
 
##################
### model_name ###
##################

# view model name
model_name(sso)

# change model name
sso <- model_name(sso, "some other name")
identical(model_name(sso), "some other name")

}
\seealso{
\code{\link{as.shinystan}} for creating \code{shinystan} objects.

\code{\link{drop_parameters}} to remove parameters from a
  \code{shinystan} object.

\code{\link{generate_quantity}} to add a new quantity to a
  \code{shinystan} object.
}
