% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{SpatialImage-methods}
\alias{SpatialImage-methods}
\alias{Cells.SpatialImage}
\alias{DefaultAssay.SpatialImage}
\alias{DefaultAssay<-.SpatialImage}
\alias{GetImage.SpatialImage}
\alias{GetTissueCoordinates.SpatialImage}
\alias{IsGlobal.SpatialImage}
\alias{Key.SpatialImage}
\alias{Key<-.SpatialImage}
\alias{Radius.SpatialImage}
\alias{RenameCells.SpatialImage}
\alias{[.SpatialImage}
\alias{dim.SpatialImage}
\alias{subset.SpatialImage}
\alias{show,SpatialImage-method}
\title{\code{SpatialImage} methods}
\usage{
\method{Cells}{SpatialImage}(x, ...)

\method{DefaultAssay}{SpatialImage}(object, ...)

\method{DefaultAssay}{SpatialImage}(object, ...) <- value

\method{GetImage}{SpatialImage}(object, mode = c("grob", "raster", "plotly", "raw"), ...)

\method{GetTissueCoordinates}{SpatialImage}(object, ...)

\method{IsGlobal}{SpatialImage}(object, ...)

\method{Key}{SpatialImage}(object, ...)

\method{Key}{SpatialImage}(object, ...) <- value

\method{Radius}{SpatialImage}(object, ...)

\method{RenameCells}{SpatialImage}(object, new.names = NULL, ...)

\method{[}{SpatialImage}(x, i, ...)

\method{dim}{SpatialImage}(x)

\method{subset}{SpatialImage}(x, cells, ...)

\S4method{show}{SpatialImage}(object)
}
\arguments{
\item{x, object}{A \code{SpatialImage}-derived object}

\item{...}{Arguments passed to other methods}

\item{value}{Depends on the method:
\describe{
 \item{\code{DefaultAssay<-}}{Assay that the image should be
 associated with}
 \item{\code{Key<-}}{New key for the image}
}}

\item{mode}{How to return the image; should accept one of \dQuote{grob},
\dQuote{raster}, \dQuote{plotly}, or \dQuote{raw}}

\item{new.names}{vector of new cell names}

\item{i, cells}{A vector of cells to keep}
}
\value{
\strong{[Override]} \code{Cells}: should return cell names

\code{DefaultAssay}: The associated assay of a
\code{SpatialImage}-derived object

\code{DefaultAssay<-}: \code{object} with the associated assay
updated

\strong{[Override]} \code{GetImage}: The image data from a
\code{SpatialImage}-derived object

\strong{[Override]} \code{GetTissueCoordinates}: ...

\code{IsGlobal}: returns \code{TRUE} as images are, by default,
global

\code{Key}: The key for a \code{SpatialImage}-derived object

\code{Key<-}: \code{object} with the key set to \code{value}

\code{Radius}: The spot radius size; by default, returns \code{NULL}

\strong{[Override]} \code{RenameCells}: \code{object} with the new
cell names

\code{[}, \code{subset}: \code{x}/\code{object} for only the cells
requested

\strong{[Override]} \code{dim}: The dimensions of the image data in
(Y, X) format

\code{show}: Prints summary to \code{\link[base]{stdout}} and
invisibly returns \code{NULL}
}
\description{
Methods defined on the \code{\link{SpatialImage}} class. Some of these
methods must be overridden in order to ensure proper functionality of the
derived classes (see \strong{Required methods} below). Other methods are
designed to work across all \code{SpatialImage}-derived subclasses, and
should only be overridden if necessary
}
\section{Functions}{
\itemize{
\item \code{Cells(SpatialImage)}: Get the cell names from an image
(\strong{[Override]})

\item \code{DefaultAssay(SpatialImage)}: Get the associated assay of a
\code{SpatialImage}-derived object

\item \code{DefaultAssay(SpatialImage) <- value}: Set the associated assay of a
\code{SpatialImage}-derived object

\item \code{GetImage(SpatialImage)}: Get the image data from a
\code{SpatialImage}-derived object

\item \code{GetTissueCoordinates(SpatialImage)}: Get tissue coordinates for a
\code{SpatialImage}-derived object (\strong{[Override]})

\item \code{IsGlobal(SpatialImage)}: Globality test for
\code{SpatialImage}-derived object

\item \code{Key(SpatialImage)}: Get the key for a
\code{SpatialImage}-derived object

\item \code{Key(SpatialImage) <- value}: Set the key for a
\code{SpatialImage}-derived object

\item \code{Radius(SpatialImage)}: Get the spot radius size

\item \code{RenameCells(SpatialImage)}: Rename cells in a
\code{SpatialImage}-derived object (\strong{[Override]})

\item \code{[}: Subset a \code{SpatialImage}-derived object

\item \code{dim(SpatialImage)}: Get the plotting dimensions of an image
(\strong{[Override]})

\item \code{subset(SpatialImage)}: Subset a \code{SpatialImage}-derived object
(\strong{[Override]})

\item \code{show(SpatialImage)}: Overview of a \code{SpatialImage}-derived
object

}}
\section{Provided methods}{

These methods are defined on the \code{SpatialImage} object and should not
be overridden without careful thought
\itemize{
  \item \code{\link{DefaultAssay}} and \code{\link{DefaultAssay<-}}
  \item \code{\link{Key}} and \code{\link{Key<-}}
  \item \code{\link{GetImage}}; this method \emph{can} be overridden to
  provide image data, normally returns empty image data. If overridden,
  should default to returning a  \code{\link[grid]{grob}} object
  \item \code{\link{IsGlobal}}
  \item \code{\link{Radius}}; this method \emph{can} be overridden to
  provide a spot radius for image objects
  \item \code{\link[base:Extract]{[}}; this method \emph{can} be overridden
  to change default subset behavior, normally returns
  \code{subset(x = x, cells = i)}. If overridden, should only accept \code{i}
}
}

\section{Required methods}{

All subclasses of the \code{SpatialImage} class must define the following
methods; simply relying on the \code{SpatialImage} method will result in
errors. For required parameters and their values, see the \code{Usage} and
\code{Arguments} sections
\describe{
  \item{\code{\link{Cells}}}{
   Return the cell/spot barcodes associated with each position
  }
  \item{\code{\link{dim}}}{
   Return the dimensions of the image for plotting in \code{(Y, X)} format
  }
  \item{\code{\link{GetTissueCoordinates}}}{
   Return tissue coordinates; by default, must return a two-column
   \code{data.frame} with x-coordinates in the first column and
   y-coordinates in the second
  }
  \item{\code{\link{Radius}}}{
   Return the spot radius; returns \code{NULL} by default for use with
   non-spot image technologies
  }
  \item{\code{\link{RenameCells}}}{
   Rename the cell/spot barcodes for this image
  }
  \item{\code{\link{subset}}}{
   Subset the image data by cells/spots
  }
}
These methods are used throughout Seurat, so defining them and setting the
proper defaults will allow subclasses of \code{SpatialImage} to work
seamlessly
}

\seealso{
\code{\link{DefaultAssay}}

\code{\link{GetImage}}

\code{\link{GetTissueCoordinates}}

\code{\link{IsGlobal}}

\code{\link{Key}}

\code{\link{RenameCells}}
}
\concept{spatialimage}
