% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{BridgeCellsRepresentation}
\alias{BridgeCellsRepresentation}
\title{Construct a dictionary representation for each unimodal dataset}
\usage{
BridgeCellsRepresentation(
  object.list,
  bridge.object,
  object.reduction,
  bridge.reduction,
  laplacian.reduction = "lap",
  laplacian.dims = 1:50,
  bridge.assay.name = "Bridge",
  return.all.assays = FALSE,
  l2.norm = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{object.list}{A list of Seurat objects}

\item{bridge.object}{A multi-omic bridge Seurat which is used as the basis to
represent unimodal datasets}

\item{object.reduction}{A list of dimensional reductions from object.list used
to be reconstructed by bridge.object}

\item{bridge.reduction}{A list of dimensional reductions from bridge.object used
to reconstruct object.reduction}

\item{laplacian.reduction}{Name of bridge graph laplacian dimensional reduction}

\item{laplacian.dims}{Dimensions used for bridge graph laplacian dimensional reduction}

\item{bridge.assay.name}{Assay name used for bridge object reconstruction value (default is 'Bridge')}

\item{return.all.assays}{Whether to return all assays in the object.list.
Only bridge assay is returned by default.}

\item{l2.norm}{Whether to l2 normalize the dictionary representation}

\item{verbose}{Print messages and progress}
}
\value{
Returns a object list in which each object has a bridge cell derived assay
}
\description{
Construct a dictionary representation for each unimodal dataset
}
\concept{integration}
