% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\docType{class}
\name{SCTAssay-class}
\alias{SCTAssay-class}
\alias{SCTModel}
\alias{SCTAssay}
\alias{levels.SCTAssay}
\alias{levels<-.SCTAssay}
\title{The SCTModel Class}
\usage{
\method{levels}{SCTAssay}(x)

\method{levels}{SCTAssay}(x) <- value
}
\arguments{
\item{x}{An \code{SCTAssay} object}

\item{value}{New levels, must be in the same order as the levels present}
}
\value{
\code{levels}: SCT model names

\code{levels<-}: \code{x} with updated SCT model names
}
\description{
The SCTModel object is a model and parameters storage from SCTransform.
It can be used to calculate Pearson residuals for new genes.

The SCTAssay object contains all the information found in an \code{\link{Assay}}
object, with extra information from the results of \code{\link{SCTransform}}
}
\section{Slots}{

\describe{
\item{\code{feature.attributes}}{A data.frame with feature attributes in SCTransform}

\item{\code{cell.attributes}}{A data.frame with cell attributes in SCTransform}

\item{\code{clips}}{A list of two numeric of length two specifying the min and max
values the Pearson residual will be clipped to. One for vst and one for
SCTransform}

\item{\code{umi.assay}}{Name of the assay of the seurat object containing UMI matrix
and the default is RNA}

\item{\code{model}}{A formula used in SCTransform}

\item{\code{arguments}}{other information used in SCTransform}

\item{\code{median_umi}}{Median UMI (or scale factor) used to calculate corrected counts}

\item{\code{SCTModel.list}}{A list containing SCT models}
}}

\section{Get and set SCT model names}{

SCT results are named by initial run of \code{\link{SCTransform}} in order
to keep SCT parameters straight between runs. When working with merged
\code{SCTAssay} objects, these model names are important. \code{levels}
allows querying the models present. \code{levels<-} allows the changing of
the names of the models present, useful when merging \code{SCTAssay} objects.
Note: unlike normal \code{\link[base]{levels<-}}, \code{levels<-.SCTAssay}
allows complete changing of model names, not reordering.
}

\section{Creating an \code{SCTAssay} from an \code{Assay}}{

Conversion from an \code{Assay} object to an \code{SCTAssay} object by
is done by adding the additional slots to the object. If \code{from} has
results generated by \code{\link{SCTransform}} from Seurat v3.0.0 to v3.1.1,
the conversion will automagically fill the new slots with the data
}

\examples{
\dontrun{
# SCTAssay objects are generated from SCTransform
pbmc_small <- SCTransform(pbmc_small)
}

# SCTAssay objects are generated from SCTransform
pbmc_small <- SCTransform(pbmc_small)
pbmc_small[["SCT"]]

\dontrun{
# Query and change SCT model names
levels(pbmc_small[['SCT']])
levels(pbmc_small[['SCT']]) <- '3'
levels(pbmc_small[['SCT']])
}

}
\seealso{
\code{\link{Assay}}

\code{\link{Assay}}
}
\concept{objects}
