% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixscape.R
\name{CalcPerturbSig}
\alias{CalcPerturbSig}
\title{Calculate a perturbation Signature}
\usage{
CalcPerturbSig(
  object,
  assay = NULL,
  features = NULL,
  slot = "data",
  gd.class = "guide_ID",
  nt.cell.class = "NT",
  split.by = NULL,
  num.neighbors = NULL,
  reduction = "pca",
  ndims = 15,
  new.assay.name = "PRTB",
  verbose = TRUE
)
}
\arguments{
\item{object}{An object of class Seurat.}

\item{assay}{Name of Assay PRTB  signature is being calculated on.}

\item{features}{Features to compute PRTB signature for. Defaults to the
variable features set in the assay specified.}

\item{slot}{Data slot to use for PRTB signature calculation.}

\item{gd.class}{Metadata column containing target gene classification.}

\item{nt.cell.class}{Non-targeting gRNA cell classification identity.}

\item{split.by}{Provide metadata column if multiple biological replicates
exist to calculate PRTB signature for every replicate separately.}

\item{num.neighbors}{Number of nearest neighbors to consider.}

\item{reduction}{Reduction method used to calculate nearest neighbors.}

\item{ndims}{Number of dimensions to use from dimensionality reduction method.}

\item{new.assay.name}{Name for the new assay.}

\item{verbose}{Display progress + messages}
}
\value{
Returns a Seurat object with a new assay added containing the
perturbation signature for all cells in the data slot.
}
\description{
Function to calculate perturbation signature for pooled CRISPR screen datasets.
For each target cell (expressing one target gRNA), we identified 20 cells
from the control pool (non-targeting cells) with the most similar mRNA
expression profiles. The perturbation signature is calculated by subtracting the
averaged mRNA expression profile of the non-targeting neighbors from the mRNA
expression profile of the target cell.
}
\concept{mixscape}
