% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{VariableFeaturePlot}
\alias{VariableFeaturePlot}
\alias{VariableGenePlot}
\alias{MeanVarPlot}
\title{View variable features}
\usage{
VariableFeaturePlot(
  object,
  cols = c("black", "red"),
  pt.size = 1,
  log = NULL,
  selection.method = NULL,
  assay = NULL
)
}
\arguments{
\item{object}{Seurat object}

\item{cols}{Colors to specify non-variable/variable status}

\item{pt.size}{Size of the points on the plot}

\item{log}{Plot the x-axis in log scale}

\item{selection.method}{Which method to pull; choose one from \code{c('sctransform', 'sct')}
or \code{c('mean.var.plot', 'dispersion', 'mvp', 'disp')}}

\item{assay}{Assay to pull variable features from}
}
\value{
A ggplot object
}
\description{
View variable features
}
\examples{
VariableFeaturePlot(object = pbmc_small)

}
\seealso{
\code{\link{FindVariableFeatures}}
}
