% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{Tool}
\alias{Tool}
\alias{Tools}
\alias{Tool<-}
\alias{Tool.Seurat}
\alias{Tool<-.Seurat}
\title{Get and set additional tool data}
\usage{
Tool(object, ...)

Tool(object, ...) <- value

\method{Tool}{Seurat}(object, slot = NULL, ...)

\method{Tool}{Seurat}(object, ...) <- value
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{value}{Information to be added to tool list}

\item{slot}{Name of tool to pull}
}
\value{
If no additional arguments, returns the names of the tools in the
object; otherwise returns the data placed by the tool requested
}
\description{
Use \code{Tool} to get tool data. If no additional arguments are provided,
will return a vector with the names of tools in the object.
}
\note{
For developers: set tool data using \code{Tool<-}. \code{Tool<-} will
automatically set the name of the tool to the function that called \code{Tool<-},
so each function gets one entry in the tools list and cannot overwrite another
function's entry. The automatic naming will also remove any method identifiers
(eg. RunPCA.Seurat will become RunPCA); please plan accordingly.
}
\examples{
Tool(object = pbmc_small)

\dontrun{
sample.tool.output <- matrix(data = rnorm(n = 16), nrow = 4)
# must be run from within a function
Tool(object = pbmc_small) <- sample.tool.output
}
}
