% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{HVFInfo}
\alias{HVFInfo}
\alias{HVFInfo.Assay}
\alias{HVFInfo.Seurat}
\title{Get highly variable feature information}
\usage{
HVFInfo(object, ...)

\method{HVFInfo}{Assay}(object, selection.method, status = FALSE, ...)

\method{HVFInfo}{Seurat}(object, selection.method = NULL, assay = NULL, status = FALSE, ...)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{selection.method}{Which method to pull; choose one from \code{c('sctransform', 'sct')}
or \code{c('mean.var.plot', 'dispersion', 'mvp', 'disp')}}

\item{status}{Add variable status to the resulting data.frame}

\item{assay}{Name of assay to pull highly variable feature information for}
}
\value{
A dataframe with feature means, dispersion, and scaled dispersion
}
\description{
Get highly variable feature information
}
\examples{
# Get the HVF info directly from an Assay object
HVFInfo(object = pbmc_small[["RNA"]], selection.method = 'vst')[1:5, ]

# Get the HVF info from a specific Assay in a Seurat object
HVFInfo(object = pbmc_small, assay = "RNA")[1:5, ]

}
