% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/clustering.R
\name{FindNeighbors}
\alias{FindNeighbors}
\alias{FindNeighbors.default}
\alias{FindNeighbors.Assay}
\alias{FindNeighbors.dist}
\alias{FindNeighbors.Seurat}
\title{SNN Graph Construction}
\usage{
FindNeighbors(object, ...)

\method{FindNeighbors}{default}(
  object,
  distance.matrix = FALSE,
  k.param = 20,
  compute.SNN = TRUE,
  prune.SNN = 1/15,
  nn.method = "rann",
  annoy.metric = "euclidean",
  nn.eps = 0,
  verbose = TRUE,
  force.recalc = FALSE,
  ...
)

\method{FindNeighbors}{Assay}(
  object,
  features = NULL,
  k.param = 20,
  compute.SNN = TRUE,
  prune.SNN = 1/15,
  nn.method = "rann",
  annoy.metric = "euclidean",
  nn.eps = 0,
  verbose = TRUE,
  force.recalc = FALSE,
  ...
)

\method{FindNeighbors}{dist}(
  object,
  k.param = 20,
  compute.SNN = TRUE,
  prune.SNN = 1/15,
  nn.method = "rann",
  annoy.metric = "euclidean",
  nn.eps = 0,
  verbose = TRUE,
  force.recalc = FALSE,
  ...
)

\method{FindNeighbors}{Seurat}(
  object,
  reduction = "pca",
  dims = 1:10,
  assay = NULL,
  features = NULL,
  k.param = 20,
  compute.SNN = TRUE,
  prune.SNN = 1/15,
  nn.method = "rann",
  annoy.metric = "euclidean",
  nn.eps = 0,
  verbose = TRUE,
  force.recalc = FALSE,
  do.plot = FALSE,
  graph.name = NULL,
  ...
)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{distance.matrix}{Boolean value of whether the provided matrix is a
distance matrix; note, for objects of class \code{dist}, this parameter will
be set automatically}

\item{k.param}{Defines k for the k-nearest neighbor algorithm}

\item{compute.SNN}{also compute the shared nearest neighbor graph}

\item{prune.SNN}{Sets the cutoff for acceptable Jaccard index when
computing the neighborhood overlap for the SNN construction. Any edges with
values less than or equal to this will be set to 0 and removed from the SNN
graph. Essentially sets the strigency of pruning (0 --- no pruning, 1 ---
prune everything).}

\item{nn.method}{Method for nearest neighbor finding. Options include: rann,
annoy}

\item{annoy.metric}{Distance metric for annoy. Options include: euclidean,
cosine, manhattan, and hamming}

\item{nn.eps}{Error bound when performing nearest neighbor seach using RANN;
default of 0.0 implies exact nearest neighbor search}

\item{verbose}{Whether or not to print output to the console}

\item{force.recalc}{Force recalculation of SNN.}

\item{features}{Features to use as input for building the SNN}

\item{reduction}{Reduction to use as input for building the SNN}

\item{dims}{Dimensions of reduction to use as input}

\item{assay}{Assay to use in construction of SNN}

\item{do.plot}{Plot SNN graph on tSNE coordinates}

\item{graph.name}{Optional naming parameter for stored SNN graph. Default is
assay.name_snn.}
}
\value{
Returns the object with object@snn filled
}
\description{
Constructs a Shared Nearest Neighbor (SNN) Graph for a given dataset. We
first determine the k-nearest neighbors of each cell. We use this knn graph
to construct the SNN graph by calculating the neighborhood overlap
(Jaccard index) between every cell and its k.param nearest neighbors.
}
\examples{
pbmc_small
# Compute an SNN on the gene expression level
pbmc_small <- FindNeighbors(pbmc_small, features = VariableFeatures(object = pbmc_small))

# More commonly, we build the SNN on a dimensionally reduced form of the data
# such as the first 10 principle components.

pbmc_small <- FindNeighbors(pbmc_small, reduction = "pca", dims = 1:10)

}
