% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{DefaultAssay}
\alias{DefaultAssay}
\alias{DefaultAssay<-}
\alias{DefaultAssay.Assay}
\alias{DefaultAssay.DimReduc}
\alias{DefaultAssay.Graph}
\alias{DefaultAssay.Seurat}
\alias{DefaultAssay.SeuratCommand}
\alias{DefaultAssay<-.Seurat}
\title{Get and set the default assay}
\usage{
DefaultAssay(object, ...)

DefaultAssay(object, ...) <- value

\method{DefaultAssay}{Assay}(object, ...)

\method{DefaultAssay}{DimReduc}(object, ...)

\method{DefaultAssay}{Graph}(object, ...)

\method{DefaultAssay}{Seurat}(object, ...)

\method{DefaultAssay}{SeuratCommand}(object, ...)

\method{DefaultAssay}{Seurat}(object, ...) <- value
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{value}{Name of assay to set as default}
}
\value{
The name of the default assay

An object with the new default assay
}
\description{
Get and set the default assay
}
\examples{
# Get current default assay
DefaultAssay(object = pbmc_small)

# Create dummy new assay to demo switching default assays
new.assay <- pbmc_small[["RNA"]]
Key(object = new.assay) <- "RNA2_"
pbmc_small[["RNA2"]] <- new.assay
# switch default assay to RNA2
DefaultAssay(object = pbmc_small) <- "RNA2"
DefaultAssay(object = pbmc_small)

}
