\name{getRNG}
\alias{getRNG}
\alias{getRNG.default}

\title{get the RNG and seed from an object}
\description{
Get the random number generator and seed used to generate an object.
}
\usage{
    getRNG(e=NULL)
    \method{getRNG}{default}(e=NULL)
}
\arguments{
    \item{e}{an object generated by simulation (which stored the RNG 
    information).}
}
\value{The random seed and other random number generation information
   used to generate the object. }
\details{Extract the RNG information used to generate the object. If \code{e}
   is \code{NULL} then \code{getRNG} returns the RNG setting, as 
   returned by \code{setRNG()}. Otherwise,
   the default method assumes the object is a list and the RNG information 
   is in the element \code{rng} or \code{noise\$rng}.
   }
\seealso{
\code{\link{setRNG}},
\code{\link{.Random.seed}}
}
\examples{
\dontrun{
if (require("dse")) {
  data("eg1.DSE.data.diff", package="dse")
  model <- estVARXls(eg1.DSE.data.diff)
  sim <- simulate(model)
  getRNG(sim)
  }
}
}
\keyword{ts}
\keyword{programming}
\keyword{utilities}
