% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareFit.R
\docType{class}
\name{FitDiff-class}
\alias{FitDiff-class}
\alias{show,FitDiff-method}
\alias{summary,FitDiff-method}
\title{Class For Representing A Template of Model Fit Comparisons}
\usage{
\S4method{show}{FitDiff}(object)

\S4method{summary}{FitDiff}(object, fit.measures = "default", nd = 3,
  tag = "†")
}
\arguments{
\item{object}{object of class \code{FitDiff}}

\item{fit.measures}{\code{character} vector naming fit indices the user can
request from \code{\link[lavaan:fitMeasures]{lavaan::fitMeasures()}}. If \code{"default"}, the
fit measures will be \code{c("chisq", "df", "pvalue", "cfi", "tli", "rmsea", "srmr", "aic", "bic")}. If \code{"all"}, all available fit
measures will be returned.}

\item{nd}{number of digits printed}

\item{tag}{single \code{character} used to flag the model preferred by each
fit index. To omit tags, set to \code{NULL} or \code{NA}.}
}
\description{
This class contains model fit measures and model fit comparisons among
multiple models
}
\section{Slots}{

\describe{
\item{\code{name}}{\code{character}. The name of each model}

\item{\code{model.class}}{\code{character}. One class to which each model belongs}

\item{\code{nested}}{\code{data.frame}. Model fit comparisons between adjacently
nested models that are ordered by their degrees of freedom (\emph{df})}

\item{\code{fit}}{\code{data.frame}. Fit measures of all models specified in the
\code{name} slot, ordered by their \emph{df}}

\item{\code{fit.diff}}{\code{data.frame}. Sequential differences in fit measures in
the \code{fit} slot}
}}

\section{Objects from the Class}{
 Objects can be created via the
\code{\link[=compareFit]{compareFit()}} function.
}

\examples{

HS.model <- ' visual  =~ x1 + x2 + x3
              textual =~ x4 + x5 + x6
              speed   =~ x7 + x8 + x9 '
fit.config <- cfa(HS.model, data = HolzingerSwineford1939, group = "school")
## invariance constraints
fit.metric <- cfa(HS.model, data = HolzingerSwineford1939, group = "school",
                  group.equal = "loadings")
fit.scalar <- cfa(HS.model, data = HolzingerSwineford1939, group = "school",
                  group.equal = c("loadings","intercepts"))
fit.strict <- cfa(HS.model, data = HolzingerSwineford1939, group = "school",
                  group.equal = c("loadings","intercepts","residuals"))
measEqOut <- compareFit(fit.config, fit.metric, fit.scalar, fit.strict)
summary(measEqOut)
summary(measEqOut, fit.measures = "all")
summary(measEqOut, fit.measures = c("aic", "bic"))

if(interactive()){
## Save results to a file
saveFile(measEqOut, file = "measEq.txt")

## Copy to a clipboard
clipboard(measEqOut)
}

}
\seealso{
\code{\link[=compareFit]{compareFit()}}; \code{\link[=clipboard]{clipboard()}}
}
\author{
Terrence D. Jorgensen (University of Amsterdam;
\email{TJorgensen314@gmail.com})

Sunthud Pornprasertmanit (\email{psunthud@gmail.com})
}
