% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2-predicates.R
\name{s2_contains}
\alias{s2_contains}
\alias{s2_within}
\alias{s2_covered_by}
\alias{s2_covers}
\alias{s2_disjoint}
\alias{s2_intersects}
\alias{s2_equals}
\alias{s2_intersects_box}
\alias{s2_touches}
\alias{s2_dwithin}
\title{S2 Geography Predicates}
\usage{
s2_contains(x, y, options = s2_options(model = "open"))

s2_within(x, y, options = s2_options(model = "open"))

s2_covered_by(x, y, options = s2_options(model = "closed"))

s2_covers(x, y, options = s2_options(model = "closed"))

s2_disjoint(x, y, options = s2_options())

s2_intersects(x, y, options = s2_options())

s2_equals(x, y, options = s2_options())

s2_intersects_box(
  x,
  lng1,
  lat1,
  lng2,
  lat2,
  detail = 1000,
  options = s2_options()
)

s2_touches(x, y, options = s2_options())

s2_dwithin(x, y, distance, radius = s2_earth_radius_meters())
}
\arguments{
\item{x}{\link[=as_s2_geography]{geography vectors}. These inputs
are passed to \code{\link[=as_s2_geography]{as_s2_geography()}}, so you can pass other objects
(e.g., character vectors of well-known text) directly.}

\item{y}{\link[=as_s2_geography]{geography vectors}. These inputs
are passed to \code{\link[=as_s2_geography]{as_s2_geography()}}, so you can pass other objects
(e.g., character vectors of well-known text) directly.}

\item{options}{An \code{\link[=s2_options]{s2_options()}} object describing the polygon/polyline
model to use and the snap level.}

\item{lng1, lat1, lng2, lat2}{A latitude/longitude range}

\item{detail}{The number of points with which to approximate
non-geodesic edges.}

\item{distance}{A distance on the surface of the earth in the same units
as \code{radius}.}

\item{radius}{Radius of the earth. Defaults to the average radius of
the earth in meters as defined by \code{\link[=s2_earth_radius_meters]{s2_earth_radius_meters()}}.}
}
\description{
These functions operate two geography vectors (pairwise), and return
a logical vector.
}
\section{Model}{

The geometry model indicates whether or not a geometry includes its boundaries.
Boundaries of line geometries are its end points.
OPEN geometries do not contain their boundary (\code{model = "open"}); CLOSED
geometries (\code{model = "closed"}) contain their boundary; SEMI-OPEN geometries
(\code{model = "semi-open"}) contain half of their boundaries, such that when two polygons
do not overlap or two lines do not cross, no point exist that belong to
more than one of the geometries. (This latter form, half-closed, is
not present in the OpenGIS "simple feature access" (SFA) standard nor DE9-IM on
which that is based). The default values for \code{\link[=s2_contains]{s2_contains()}} (open)
and covers/covered_by (closed) correspond to the SFA standard specification
of these operators.
}

\examples{
s2_contains(
  "POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))",
  c("POINT (5 5)", "POINT (-1 1)")
)

s2_within(
  c("POINT (5 5)", "POINT (-1 1)"),
  "POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))"
)

s2_covered_by(
  "POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))",
  c("POINT (5 5)", "POINT (-1 1)")
)

s2_covers(
  "POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))",
  c("POINT (5 5)", "POINT (-1 1)")
)

s2_disjoint(
  "POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))",
  c("POINT (5 5)", "POINT (-1 1)")
)

s2_intersects(
  "POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))",
  c("POINT (5 5)", "POINT (-1 1)")
)

s2_equals(
  "POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))",
  c(
    "POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))",
    "POLYGON ((10 0, 10 10, 0 10, 0 0, 10 0))",
    "POLYGON ((-1 -1, 10 0, 10 10, 0 10, -1 -1))"
  )
)

s2_intersects(
  "POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))",
  c("POINT (5 5)", "POINT (-1 1)")
)

s2_intersects_box(
  c("POINT (5 5)", "POINT (-1 1)"),
  0, 0, 10, 10
)

s2_touches(
  "POLYGON ((0 0, 0 1, 1 1, 0 0))",
  c("POINT (0 0)", "POINT (0.5 0.75)", "POINT (0 0.5)")
)

s2_dwithin(
  "POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))",
  c("POINT (5 5)", "POINT (-1 1)"),
  0 # distance in meters
)

s2_dwithin(
  "POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))",
  c("POINT (5 5)", "POINT (-1 1)"),
  1e6 # distance in meters
)

}
\seealso{
Matrix versions of these predicates (e.g., \code{\link[=s2_intersects_matrix]{s2_intersects_matrix()}}).

BigQuery's geography function reference:
\itemize{
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_contains}{ST_CONTAINS}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_coveredby}{ST_COVEREDBY}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_covers}{ST_COVERS}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_disjoint}{ST_DISJOINT}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_equals}{ST_EQUALS}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_intersects}{ST_INTERSECTS}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_intersectsbox}{ST_INTERSECTSBOX}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_touches}{ST_TOUCHES}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_within}{ST_WITHIN}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_dwithin}{ST_DWITHIN}
}
}
