% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terminal.R
\name{terminalActivate}
\alias{terminalActivate}
\title{Activate Terminal}
\usage{
terminalActivate(id = NULL, show = TRUE)
}
\arguments{
\item{id}{The terminal id. The \code{id} is obtained from
\code{\link{terminalList}()}, \code{\link{terminalVisible}()},
\code{\link{terminalCreate}()}, or \code{\link{terminalExecute}()}.
If NULL, the terminal tab will be selected but no specific terminal
will be chosen.}

\item{show}{If TRUE, bring the terminal to front in RStudio.}
}
\description{
Ensure terminal is running and optionally bring to front in RStudio.
}
\note{
The \code{terminalActivate} function was added in version 1.1.350 of RStudio.
}
\examples{
\dontrun{
# create a hidden terminal and run a lengthy command
termId = rstudioapi::terminalCreate(show = FALSE)
rstudioapi::terminalSend(termId, "sleep 5\n")

# wait until a busy terminal is finished
while (rstudioapi::terminalBusy(termId)) {
  Sys.sleep(0.1)
}
print("Terminal available")#'

rstudioapi::terminalActivate(termId)
}

}
