% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapiro_test.R
\name{shapiro_test}
\alias{shapiro_test}
\alias{mshapiro_test}
\title{Shapiro-Wilk Normality Test}
\usage{
shapiro_test(data, ..., vars = NULL)

mshapiro_test(data)
}
\arguments{
\item{data}{a data frame. Columns are variables.}

\item{...}{One or more unquoted expressions (or variable names) separated by
commas. Used to select a variable of interest.}

\item{vars}{optional character vector containing variable names. Ignored when
dot vars are specified.}
}
\value{
a data frame containing the value of the Shapiro-Wilk statistic and
  the corresponding p.value.
}
\description{
Provides a pipe-friendly framework to performs Shapiro-Wilk test
  of normality. Support grouped data and multiple variables for multivariate
  normality tests. Wrapper around the R base function
  \code{\link[stats]{shapiro.test}()}. Can handle grouped data. Read more:
  \href{https://www.datanovia.com/en/lessons/normality-test-in-r/}{Normality
  Test in R}.
}
\section{Functions}{
\itemize{
\item \code{shapiro_test}: univariate Shapiro-Wilk normality test

\item \code{mshapiro_test}: multivariate Shapiro-Wilk normality test. This is a
modified copy of the \code{mshapiro.test()} function of the package
mvnormtest, for internal convenience.
}}

\examples{

# Shapiro Wilk normality test for one variable
iris \%>\% shapiro_test(Sepal.Length)

# Shapiro Wilk normality test for two variables
iris \%>\% shapiro_test(Sepal.Length, Petal.Width)

# Multivariate normality test
mshapiro_test(iris[, 1:3])

}
