% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readSDMX.R
\name{readSDMX}
\alias{readSDMX}
\title{readSDMX}
\usage{
readSDMX(file, isURL, isRData,
                provider, providerId, providerKey,
                agencyId, resource, resourceId, version,
                flowRef, key, key.mode, start, end, dsd, validate, verbose)
}
\arguments{
\item{file}{path to SDMX-ML document that needs to be parsed}

\item{isURL}{a value of class "logical" either the path is an url, and data
has to be downloaded from a SDMXweb-repository. Default value is TRUE.
Ignored in case \code{readSDMX} is used with helpers (based on the
embedded list of \code{SDMXServiceProvider})}

\item{isRData}{a value of class "logical" either the path is local RData file
handling an object of class "SDMX", previously saved with \code{\link{saveSDMX}}.
Default value is FALSE.}

\item{provider}{an object of class "SDMXServiceProvider". If specified,
\code{file} and \code{isURL} arguments will be ignored.}

\item{providerId}{an object of class "character" representing a provider id.
It has to be match a default provider as listed in\code{getSDMXServiceProviders()}}

\item{providerKey}{an object of class "character" giving a key to authenticate
for the given provider endpoint. Some providers may require an authentication or
subscription key to perform SDMX requests.}

\item{agencyId}{an object of class "character representing an agency id, for
which data should be requested (from a particular service provider)}

\item{resource}{an object of class "character" giving the SDMX service request
resource to query e.g. "data". Recognized if a valid provider or provide
id has been specified as argument.}

\item{resourceId}{an object of class "character" giving a SDMX service resource
Id, e.g. the id of a data structure}

\item{version}{an object of class "character" giving a SDMX resource version,
e.g. the version of a dataflow.}

\item{flowRef}{an object of class "character" giving the SDMX flow ref id. Recognized
if valid provider or provide id has been specified as argument.}

\item{key}{an object of class "character" or "list" giving the SDMX data key/filter
to apply. Recognized if a valid provider or provide id has been specified as argument.
If \code{key.mode} is equal to \code{"R"} (default value), filter has to be an object
of class "list" representing the filters to apply to the dataset, otherwise the filter
will be a string.}

\item{key.mode}{an object of class "character" indicating if the \code{key} has to be provided
as an R object, ie a object of class "list" representing the filter(s) to apply. Default
value is \code{"R"}. Alternative value is \code{"SDMX"}}

\item{start}{an object of class "integer" or "character" giving the SDMX start time to apply.
Recognized if a valid provider or provide id has been specified as argument.}

\item{end}{an object of class "integer" or "character" giving the SDMX end time to apply.
Recognized if a valid provider or provide id has been specified as argument.}

\item{dsd}{an Object of class "logical" if an attempt to inherit the DSD should be performed.
Active only if \code{"readSDMX"} is used as helper method (ie if data is fetched using
an embedded service provider. Default is FALSE}

\item{validate}{an object of class "logical" indicating if a validation check has to
be performed on the SDMX-ML document to check its SDMX compliance when reading it.
Default is FALSE.}

\item{verbose}{an Object of class "logical" that indicates if rsdmx messages should
       appear to user. Default is TRUE.}
}
\value{
an object of class "SDMX"
}
\description{
\code{readSDMX} is the main function to use to read SDMX data
}
\examples{
# SDMX datasets
 #--------------
 \dontrun{
   # Not run
   # (local dataset examples)
   #with SDMX 2.0
   tmp <- system.file("extdata","Example_Eurostat_2.0.xml", package="rsdmx")
   sdmx <- readSDMX(tmp, isURL = FALSE)
   stats <- as.data.frame(sdmx)
   head(stats)

   #with SDMX 2.1
   tmpnew <- system.file("extdata","Example_Eurostat_2.1.xml", package="rsdmx")
   sdmx <- readSDMX(tmpnew, isURL = FALSE)
   stats <- as.data.frame(sdmx)
   head(stats)
   ## End(**Not run**)
 }

 \donttest{
   # Not run by 'R CMD check'
   # (reliable remote datasource but with possible occasional unavailability)

   #examples using embedded providers
   sdmx <- readSDMX(providerId = "OECD", resource = "data", flowRef = "MIG",
                     key = list("TOT", NULL, NULL), start = 2011, end = 2011)
   stats <- as.data.frame(sdmx)
   head(stats)

   #examples using 'file' argument
   #using url (Eurostat REST SDMX 2.1)
   url <- paste("http://ec.europa.eu/eurostat/SDMX/diss-web/rest/data/",
                "cdh_e_fos/all/?startperiod=2000&endPeriod=2010",
                sep = "")
   sdmx <- readSDMX(url)
   stats <- as.data.frame(sdmx)
   head(stats)

   ## End(**Not run**)
 }

 # SDMX DataStructureDefinition (DSD)
 #-----------------------------------
 \donttest{
   # Not run by 'R CMD check'
   # (reliable remote datasource but with possible occasional unavailability)

   #using embedded providers
   dsd <- readSDMX(providerId = "OECD", resource = "datastructure",
                   resourceId = "WATER_ABSTRACT")

   #get codelists from DSD
   cls <- slot(dsd, "codelists")
   codelists <- sapply(slot(cls,"codelists"), slot, "id") #get list of codelists

   #get a codelist
   codelist <- as.data.frame(cls, codelistId = "CL_WATER_ABSTRACT_SOURCE")

   #get concepts from DSD
   concepts <- as.data.frame(slot(dsd, "concepts"))

   ## End(**Not run**)
 }
}
\author{
Emmanuel Blondel, \email{emmanuel.blondel1@gmail.com}
}

