% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Class-SDMXDataFlow.R, R/SDMXDataFlow-methods.R
\docType{class}
\name{SDMXDataFlow}
\alias{SDMXDataFlow}
\alias{SDMXDataFlow,SDMXDataFlow-method}
\alias{SDMXDataFlow-class}
\title{Class "SDMXDataFlow"}
\usage{
SDMXDataFlow(xmlObj, namespaces)
}
\arguments{
\item{xmlObj}{object of class "XMLInternalDocument derived from XML package}

\item{namespaces}{object of class "data.frame" given the list of namespace URIs}
}
\value{
an object of class "SDMXDataFlow"
}
\description{
A basic class to handle a SDMX DataFlow
}
\section{Slots}{

\describe{
\item{\code{id}}{Object of class "character" giving the ID (required)}

\item{\code{agencyID}}{Object of class "character" giving the AgencyID}

\item{\code{version}}{Object of class "character" giving the version}

\item{\code{uri}}{Object of class "character" giving the uri}

\item{\code{urn}}{Object of class "character" giving the urn}

\item{\code{isExternalReference}}{Object of class "logical" indicating if the dataflow is an external reference}

\item{\code{isFinal}}{Object of class "logical" indicating if the dataflow is final}

\item{\code{validFrom}}{Object of class "character" indicating the start validity period}

\item{\code{validTo}}{Object of class "character" indicating the end validity period}

\item{\code{Name}}{Object of class "list" giving the dataflow (by available language) - required}

\item{\code{Description}}{Object of class "list" giving the dataflow description (by available language)}

\item{\code{dsdRef}}{Object of class "character" giving the reference datastructure Id}

\item{\code{dsd}}{Object of class "SDMXDataStructureDefinition"}
}}
\section{Warning}{

This class is not useful in itself, but all SDMX non-abstract classes will
encapsulate it as slot, when parsing an SDMX-ML document (Concepts, or
DataStructureDefinition)
}
\author{
Emmanuel Blondel, \email{emmanuel.blondel1@gmail.com}
}
\seealso{
\link{readSDMX}
}

