% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complement.R
\name{complement}
\alias{complement}
\alias{complement.rsplit}
\alias{complement.rof_split}
\alias{complement.sliding_window_split}
\alias{complement.sliding_index_split}
\alias{complement.sliding_period_split}
\alias{complement.apparent_split}
\title{Determine the Assessment Samples}
\usage{
complement(x, ...)

\method{complement}{rsplit}(x, ...)

\method{complement}{rof_split}(x, ...)

\method{complement}{sliding_window_split}(x, ...)

\method{complement}{sliding_index_split}(x, ...)

\method{complement}{sliding_period_split}(x, ...)

\method{complement}{apparent_split}(x, ...)
}
\arguments{
\item{x}{An \code{rsplit} object.}

\item{...}{Not currently used.}
}
\value{
A integer vector.
}
\description{
This method and function help find which data belong in the analysis and
assessment sets.
}
\details{
Given an \code{rsplit} object, \code{complement()} will determine which
of the data rows are contained in the assessment set. To save space,
many of the \code{rsplit} objects will not contain indices for the
assessment split.
}
\examples{
set.seed(28432)
fold_rs <- vfold_cv(mtcars)
head(fold_rs$splits[[1]]$in_id)
fold_rs$splits[[1]]$out_id
complement(fold_rs$splits[[1]])
}
\seealso{
\code{\link[=populate]{populate()}}
}
