% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd-message.R
\name{cnd_message}
\alias{cnd_message}
\alias{cnd_header}
\alias{cnd_body}
\alias{cnd_footer}
\title{Build an error message from parts}
\usage{
cnd_message(cnd)

cnd_header(cnd, ...)

cnd_body(cnd, ...)

cnd_footer(cnd, ...)
}
\arguments{
\item{cnd}{A condition object.}

\item{...}{Arguments passed to methods.}
}
\description{
\code{cnd_message()} assembles an error message from three generics:
\itemize{
\item \code{cnd_header()}
\item \code{cnd_body()}
\item \code{cnd_footer()}
}

The default method for the error header returns the \code{message} field
of the condition object. The default methods for the body and
footer return empty character vectors. In general, methods for
these generics should return a character vector. The elements are
combined into a single string with a newline separator.

\code{cnd_message()} is automatically called by the \code{conditionMessage()}
for rlang errors. Error classes created with \code{\link[=abort]{abort()}} only need to
implement header, body or footer methods. This provides a lot of
flexibility for hierarchies of error classes, for instance you
could inherit the body of an error message from a parent class
while overriding the header and footer.
}
\section{Overriding \code{cnd_body()}}{


\Sexpr[results=rd, stage=render]{rlang:::lifecycle("experimental")}

Sometimes the contents of an error message depends on the state of
your checking routine. In that case, it can be tricky to lazily
generate error messages with \code{cnd_body()}: you have the choice
between overspecifying your error class hierarchies with one class
per state, or replicating the type-checking control flow within the
\code{cnd_body()} method. None of these options are ideal.

A better option is to define a \code{body} field in your error object
containing a static string, a \link[=as_function]{lambda-formula}, or a
function with the same signature as \code{cnd_body()}. This field
overrides the \code{cnd_body()} generic and makes it easy to generate an
error message tailored to the state in which the error was
constructed.
}

