% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifecycle.R
\name{lifecycle}
\alias{lifecycle}
\title{Life cycle of the rlang package}
\description{
The rlang package is currently maturing. Unless otherwise stated,
this applies to all its exported functions. Maturing functions are
susceptible to API changes. Only use these in packages if you're
prepared to make changes as the package evolves. See sections below
for a list of functions marked as stable.

The documentation pages of retired functions contain life cycle
sections that explain the reasons for their retirements.
}
\section{Stable functions}{

\itemize{
\item \code{\link[=eval_tidy]{eval_tidy()}}
\item \link{!!}, \link{!!!}
\item \code{\link[=enquo]{enquo()}}, \code{\link[=quo]{quo()}}, \code{\link[=quos]{quos()}}
\item \code{\link[=enexpr]{enexpr()}}, \code{\link[=expr]{expr()}}, \code{\link[=exprs]{exprs()}}
\item \code{\link[=sym]{sym()}}, \code{\link[=syms]{syms()}}
\item \code{\link[=new_quosure]{new_quosure()}}, \code{\link[=is_quosure]{is_quosure()}}
\item \code{\link[=missing_arg]{missing_arg()}}, \code{\link[=is_missing]{is_missing()}}
\item \code{\link[=quo_get_expr]{quo_get_expr()}}, \code{\link[=quo_set_expr]{quo_set_expr()}}
\item \code{\link[=quo_get_env]{quo_get_env()}}, \code{\link[=quo_set_env]{quo_set_env()}}
\item \code{\link[=eval_bare]{eval_bare()}}
\item \code{\link[=set_names]{set_names()}}, \code{\link[=names2]{names2()}}
\item \code{\link[=as_function]{as_function()}}
}
}

\section{Experimental functions}{


These functions are not yet part of the rlang API. Expect breaking
changes.
\itemize{
\item \code{\link[=type_of]{type_of()}}, \code{\link[=switch_type]{switch_type()}}, \code{\link[=coerce_type]{coerce_type()}}
\item \code{\link[=switch_class]{switch_class()}}, \code{\link[=coerce_class]{coerce_class()}}
\item \code{\link[=lang_type_of]{lang_type_of()}}, \code{\link[=switch_lang]{switch_lang()}}, \code{\link[=coerce_lang]{coerce_lang()}}
\item \code{\link[=set_attrs]{set_attrs()}}, \code{\link[=mut_attrs]{mut_attrs()}}
\item \code{\link[=with_env]{with_env()}}, \code{\link[=locally]{locally()}}
\item \code{\link[=env_poke]{env_poke()}}
\item \code{\link[=env_bind_fns]{env_bind_fns()}}, \code{\link[=env_bind_exprs]{env_bind_exprs()}}
\item \code{\link[=pkg_env]{pkg_env()}}, \code{\link[=pkg_env_name]{pkg_env_name()}}
\item \code{\link[=scoped_env]{scoped_env()}}, \code{\link[=scoped_names]{scoped_names()}}, \code{\link[=scoped_envs]{scoped_envs()}}, \code{\link[=is_scoped]{is_scoped()}}
\item \code{\link[=ns_env]{ns_env()}}, \code{\link[=ns_imports_env]{ns_imports_env()}}, \code{\link[=ns_env_name]{ns_env_name()}}
\item \code{\link[=is_pairlist]{is_pairlist()}}, \code{\link[=as_pairlist]{as_pairlist()}}, \code{\link[=is_node]{is_node()}}, \code{\link[=is_node_list]{is_node_list()}}
\item \code{\link[=is_definition]{is_definition()}}, \code{\link[=new_definition]{new_definition()}}, \code{\link[=is_formulaish]{is_formulaish()}},
\code{\link[=dots_definitions]{dots_definitions()}}
\item \code{\link[=scoped_options]{scoped_options()}}, \code{\link[=with_options]{with_options()}}, \code{\link[=push_options]{push_options()}},
\code{\link[=peek_options]{peek_options()}}, \code{\link[=peek_option]{peek_option()}}
\item \code{\link[=as_bytes]{as_bytes()}}, \code{\link[=chr_unserialise_unicode]{chr_unserialise_unicode()}}, \code{\link[=set_chr_encoding]{set_chr_encoding()}},
\code{\link[=chr_encoding]{chr_encoding()}}, \code{\link[=set_str_encoding]{set_str_encoding()}}, \code{\link[=str_encoding]{str_encoding()}}
\item \code{\link[=mut_utf8_locale]{mut_utf8_locale()}}, \code{\link[=mut_latin1_locale]{mut_latin1_locale()}}, \code{\link[=mut_mbcs_locale]{mut_mbcs_locale()}}
\item \code{\link[=prepend]{prepend()}}, \code{\link[=modify]{modify()}}
}
}

\section{Questioning functions}{

\itemize{
\item \code{\link[=UQ]{UQ()}}, \code{\link[=UQS]{UQS()}}
\item \code{\link[=dots_splice]{dots_splice()}}, \code{\link[=splice]{splice()}}
\item \code{\link[=invoke]{invoke()}}
\item \code{\link[=is_frame]{is_frame()}}, \code{\link[=global_frame]{global_frame()}}, \code{\link[=current_frame]{current_frame()}},
\code{\link[=ctxt_frame]{ctxt_frame()}}, \code{\link[=call_frame]{call_frame()}}, \code{\link[=frame_position]{frame_position()}}
\item \code{\link[=ctxt_depth]{ctxt_depth()}}, \code{\link[=call_depth]{call_depth()}}, \code{\link[=ctxt_stack]{ctxt_stack()}}, \code{\link[=call_stack]{call_stack()}},
\code{\link[=stack_trim]{stack_trim()}}
}
}

\section{Soft-deprecated functions and arguments}{


\strong{Retired in rlang 0.2.0:}
\itemize{
\item \code{\link[=eval_tidy_]{eval_tidy_()}}
\item \code{\link[=overscope_clean]{overscope_clean()}}
\item \code{\link[=overscope_eval_next]{overscope_eval_next()}} => \code{\link[=eval_tidy]{eval_tidy()}}
\item \code{\link[=lang_head]{lang_head()}}, \code{\link[=lang_tail]{lang_tail()}}
}

\strong{Renamed in rlang 0.2.0:}
\itemize{
\item \code{\link[=quo_expr]{quo_expr()}} => \code{\link[=quo_squash]{quo_squash()}}
\item \code{\link[=parse_quosure]{parse_quosure()}} => \code{\link[=parse_quo]{parse_quo()}}
\item \code{\link[=parse_quosures]{parse_quosures()}} => \code{\link[=parse_quos]{parse_quos()}}
\item \code{\link[=as_overscope]{as_overscope()}} => \code{\link[=as_data_mask]{as_data_mask()}}
\item \code{\link[=new_overscope]{new_overscope()}} => \code{\link[=new_data_mask]{new_data_mask()}}
\item \code{\link[=as_dictionary]{as_dictionary()}} => \code{\link[=as_data_pronoun]{as_data_pronoun()}}
\item \code{\link[=lang]{lang()}} => \code{\link[=call2]{call2()}}
\item \code{\link[=new_language]{new_language()}} => \code{\link[=new_call]{new_call()}}
\item \code{\link[=is_lang]{is_lang()}} => \code{\link[=is_call]{is_call()}}
\item \code{\link[=is_unary_lang]{is_unary_lang()}} => Use the \code{n} argument of \code{\link[=is_call]{is_call()}}
\item \code{\link[=is_binary_lang]{is_binary_lang()}} => Use the \code{n} argument of \code{\link[=is_call]{is_call()}}
\item \code{\link[=quo_is_lang]{quo_is_lang()}} => \code{\link[=quo_is_call]{quo_is_call()}}
\item \code{\link[=is_expr]{is_expr()}} => \code{\link[=is_expression]{is_expression()}}
\item \code{\link[=lang_modify]{lang_modify()}} => \code{\link[=call_modify]{call_modify()}}
\item \code{\link[=lang_standardise]{lang_standardise()}} => \code{\link[=call_standardise]{call_standardise()}}
\item \code{\link[=lang_fn]{lang_fn()}} => \code{\link[=call_fn]{call_fn()}}
\item \code{\link[=lang_name]{lang_name()}} => \code{\link[=call_name]{call_name()}}
\item \code{\link[=lang_args]{lang_args()}} => \code{\link[=call_args]{call_args()}}
\item \code{\link[=lang_args_names]{lang_args_names()}} => \code{\link[=call_args_names]{call_args_names()}}
}
}

\section{Deprecated functions and arguments}{


\strong{Retired in rlang 0.2.0:}
\itemize{
\item \code{\link[=UQE]{UQE()}}
\item \code{\link[=is_quosureish]{is_quosureish()}}, \code{\link[=as_quosureish]{as_quosureish()}}
}

\strong{Renamed in rlang 0.2.0}
\itemize{
\item \code{\link[=new_cnd]{new_cnd()}} => \code{\link[=cnd]{cnd()}}
\item \code{\link[=cnd_message]{cnd_message()}} => \code{\link[=message_cnd]{message_cnd()}}
\item \code{\link[=cnd_warning]{cnd_warning()}} => \code{\link[=warning_cnd]{warning_cnd()}}
\item \code{\link[=cnd_error]{cnd_error()}} => \code{\link[=error_cnd]{error_cnd()}}
}
}

\section{Defunct functions and arguments}{


\strong{Retired in rlang 0.2.0:}
\itemize{
\item \link[=quasiquotation]{:=}
}
}

