% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifecycle-retired.R, R/parse.R
\name{parse_quosures}
\alias{parse_quosures}
\alias{parse_expr}
\alias{parse_exprs}
\alias{parse_quo}
\alias{parse_quos}
\title{Parse R code}
\usage{
parse_quosures(x, env = caller_env())

parse_expr(x)

parse_exprs(x)
}
\arguments{
\item{x}{Text containing expressions to parse_expr for
\code{parse_expr()} and \code{parse_exprs()}. Can also be an R connection,
for instance to a file. If the supplied connection is not open,
it will be automatically closed and destroyed.}

\item{env}{The environment for the quosures. Depending on the use
case, a good default might be the \link[=global_env]{global
environment} but you might also want to evaluate the
R code in an isolated context (perhaps a child of the global
environment or of the \link[=base_env]{base environment}).}
}
\value{
\code{parse_expr()} returns an \link[=is_expression]{expression},
\code{parse_exprs()} returns a list of expressions.
}
\description{
These functions parse and transform text into R expressions. This
is the first step to interpret or evaluate a piece of R code
written by a programmer.
}
\details{
\code{parse_expr()} returns one expression. If the text contains more
than one expression (separated by semicolons or new lines), an error is
issued. On the other hand \code{parse_exprs()} can handle multiple
expressions. It always returns a list of expressions (compare to
\code{\link[base:parse]{base::parse()}} which returns an base::expression vector). All
functions also support R connections.

The versions suffixed with \code{_quo} and \code{quos} return
\link[=quotation]{quosures} rather than raw expressions.
}
\section{Life cycle}{

\itemize{
\item \code{parse_quosure()} and \code{parse_quosures()} were soft-deprecated in
rlang 0.2.0 and renamed to \code{parse_quo()} and \code{parse_quos()}. This
is consistent with the rule that abbreviated suffixes indicate
the return type of a function.
}
}

\examples{
# parse_expr() can parse any R expression:
parse_expr("mtcars \%>\% dplyr::mutate(cyl_prime = cyl / sd(cyl))")

# A string can contain several expressions separated by ; or \\n
parse_exprs("NULL; list()\\n foo(bar)")

# You can also parse source files by passing a R connection. Let's
# create a file containing R code:
path <- tempfile("my-file.R")
cat("1; 2; mtcars", file = path)

# We can now parse it by supplying a connection:
parse_exprs(file(path))
}
\seealso{
\code{\link[base:parse]{base::parse()}}
}
