% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/python-item.R
\name{py_get_item}
\alias{py_get_item}
\alias{py_set_item}
\alias{py_del_item}
\alias{[.python.builtin.object}
\alias{[<-.python.builtin.object}
\title{Get/Set/Delete an item from a Python object}
\usage{
py_get_item(x, key, silent = FALSE)

py_set_item(x, key, value)

py_del_item(x, key)

\method{[}{python.builtin.object}(x, ...)

\method{[}{python.builtin.object}(x, ...) <- value
}
\arguments{
\item{x}{A Python object.}

\item{key, ...}{The key used for item lookup.}

\item{silent}{Boolean; when \code{TRUE}, attempts to access missing items
will return \code{NULL} rather than throw an error.}

\item{value}{The item value to set. Assigning \code{value} of \code{NULL} calls
\code{py_del_item()} and is equivalent to the python expression \verb{del x[key]}. To
set an item value of \code{None}, you can call \code{py_set_item()} directly, or call
\code{x[key] <- py_none()}}
}
\value{
For \code{py_get_item()} and \code{[}, the return value from the
\code{x.__getitem__()} method. For \code{py_set_item()}, \code{py_del_item()} and \verb{[<-},
the mutate object \code{x} is returned.
}
\description{
Access an item from a Python object, similar to how \code{x[key]} might be
used in Python code to access an item indexed by \code{key} on an object \code{x}. The
object's \verb{__getitem__()} \verb{__setitem__()} or \verb{__delitem__()} method will be
called.
}
\note{
The \code{py_get_item()} always returns an unconverted python object, while
\code{[} will automatically attempt to convert the object if \code{x} was created
with \code{convert = TRUE}.
}
\examples{
\dontrun{

## get/set/del item from Python dict
x <- r_to_py(list(abc = "xyz"))

#'   # R expression    | Python expression
# -------------------- | -----------------
 x["abc"]              # x["abc"]
 x["abc"] <- "123"     # x["abc"] = "123"
 x["abc"] <- NULL      # del x["abc"]
 x["abc"] <- py_none() # x["abc"] = None

## get item from Python list
x <- r_to_py(list("a", "b", "c"))
x[0]

## slice a NumPy array
x <- np_array(array(1:64, c(4, 4, 4)))

# R expression | Python expression
# ------------ | -----------------
  x[0]         # x[0]
  x[, 0]       # x[:, 0]
  x[, , 0]     # x[:, :, 0]

  x[NA:2]      # x[:2]
  x[`:2`]      # x[:2]

  x[2:NA]      # x[2:]
  x[`2:`]      # x[2:]

  x[NA:NA:2]   # x[::2]
  x[`::2`]     # x[::2]

  x[1:3:2]     # x[1:3:2]
  x[`1:3:2`]   # x[1:3:2]

}
}
\concept{item-related APIs}
