% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-version.R
\name{download_version}
\alias{download_version}
\title{Download a specified version of a CRAN package}
\usage{
download_version(
  package,
  version = NULL,
  repos = getOption("repos"),
  type = getOption("pkgType"),
  ...
)
}
\arguments{
\item{package}{Name of the package to install.}

\item{version}{Version of the package to install.  Can either be a string giving the exact
version required, or a specification in the same format as the parenthesized expressions used
in package dependencies. One of the following formats:
\itemize{
\item An exact version required, as a string, e.g. \code{"0.1.13"}
\item A comparison operator and a version, e.g. \code{">= 0.1.12"}
\item Several criteria to satisfy, as a comma-separated string, e.g. \code{">= 1.12.0, < 1.14"}
\item Several criteria to satisfy, as elements of a character vector, e.g. \code{c(">= 1.12.0", "< 1.14")}
}}

\item{repos}{
    character vector, the base URL(s) of the repositories
    to use, e.g., the URL of a CRAN mirror such as
    \code{"https://cloud.r-project.org"}.  For more details on
    supported URL schemes see \code{\link{url}}.

    Can be \code{NULL} to install from local files, directories or URLs:
    this will be inferred by extension from \code{pkgs} if of length one.
  }

\item{type}{character, indicating the type of package to download and
    install.  Will be \code{"source"} except on Windows and some macOS
    builds: see the section on \sQuote{Binary packages} for those.
  }

\item{...}{Other arguments passed on to \code{\link[utils:install.packages]{utils::install.packages()}}.}
}
\value{
Name of the downloaded file.
}
\description{
It downloads the package to a temporary file, and
returns the name of the file.
}
