% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/center.R
\name{step_center}
\alias{step_center}
\title{Centering Numeric Data}
\usage{
step_center(recipe, ..., role = NA, trained = FALSE, means = NULL,
  na.rm = TRUE)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of 
operations for this recipe.}

\item{...}{One or more selector functions to choose which variables are 
affected by the step. See \code{\link{selections}} for more details.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing 
have been estimated.}

\item{means}{A named numeric vector of means. This is \code{NULL} until 
computed by \code{\link{prep.recipe}}.}

\item{na.rm}{A logical value indicating whether \code{NA} values should be 
removed when averaging.}
}
\value{
An updated version of \code{recipe} with the
  new step added to the sequence of existing steps (if any).
}
\description{
\code{step_center} creates a \emph{specification} of a recipe step that 
  will normalize numeric data to have a mean of zero.
}
\details{
Centering data means that the average of a variable is subtracted 
  from the data. \code{step_center} estimates the variable means from the 
  data used in the \code{training} argument of \code{prep.recipe}. 
  \code{bake.recipe} then applies the centering to new data sets using 
  these means.
}
\examples{
data(biomass)

biomass_tr <- biomass[biomass$dataset == "Training",]
biomass_te <- biomass[biomass$dataset == "Testing",]

rec <- recipe(HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur,
              data = biomass_tr)

center_trans <- rec \%>\%
  step_center(carbon, contains("gen"), -hydrogen)

center_obj <- prep(center_trans, training = biomass_tr)

transformed_te <- bake(center_obj, biomass_te)

biomass_te[1:10, names(transformed_te)]
transformed_te
}
\seealso{
\code{\link{recipe}} \code{\link{prep.recipe}} 
  \code{\link{bake.recipe}}
}
\concept{
preprocessing normalization_methods
}
\keyword{datagen}
