% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{rcmdcheck}
\alias{rcmdcheck}
\title{Run R CMD check from R and Capture Results}
\usage{
rcmdcheck(
  path = ".",
  quiet = FALSE,
  args = character(),
  build_args = character(),
  check_dir = NULL,
  libpath = .libPaths(),
  repos = getOption("repos"),
  timeout = Inf,
  error_on = Sys.getenv("RCMDCHECK_ERROR_ON", c("never", "error", "warning",
    "note")[1]),
  env = character()
)
}
\arguments{
\item{path}{Path to a package tarball or a directory.}

\item{quiet}{Whether to print check output during checking.}

\item{args}{Character vector of arguments to pass to \verb{R CMD check}. Pass each
argument as a single element of this character vector (do not use spaces to
delimit arguments like you would in the shell). For example, to skip
running of examples and tests, use \code{args = c("--no-examples", "--no-tests")} and not \code{args = "--no-examples --no-tests"}. (Note that
instead of the \code{--output} option you should use the \code{check_dir} argument,
because  \code{--output} cannot deal with spaces and other special characters on
Windows.)}

\item{build_args}{Character vector of arguments to pass to \verb{R CMD build}.
Pass each argument as a single element of this character vector (do not use
spaces to delimit arguments like you would in the shell). For example,
\code{build_args = c("--force", "--keep-empty-dirs")} is a correct usage and
\code{build_args = "--force --keep-empty-dirs"} is incorrect.}

\item{check_dir}{Path to a directory where the check is performed.
If this is not \code{NULL}, then the a temporary directory is used, that
is cleaned up when the returned object is garbage collected.}

\item{libpath}{The library path to set for the check.
The default uses the current library path.}

\item{repos}{The \code{repos} option to set for the check.
This is needed for cyclic dependency checks if you use the
\code{--as-cran} argument. The default uses the current value.}

\item{timeout}{Timeout for the check, in seconds, or as a
\link[base:difftime]{base::difftime} object. If it is not finished before this, it will be
killed. \code{Inf} means no timeout. If the check is timed out,
that is added as an extra error to the result object.}

\item{error_on}{Whether to throw an error on \verb{R CMD check} failures.
Note that the check is always completed (unless a timeout happens),
and the error is only thrown after completion. If \code{"never"}, then
no errors are thrown. If \code{"error"}, then only \code{ERROR} failures
generate errors. If \code{"warning"}, then \code{WARNING} failures generate
errors as well. If \code{"note"}, then any check failure generated an
error. Its default can be modified with the \code{RCMDCHECK_ERROR_ON}
environment variable. If that is not set, then \code{"never"} is used.}

\item{env}{A named character vector, extra environment variables to
set in the check process.}
}
\value{
An S3 object (list) with fields \code{errors},
\code{warnings} and \code{notes}. These are all character
vectors containing the output for the failed check.
}
\description{
Run R CMD check from R programmatically, and capture the results of the
individual checks.

Runs \verb{R CMD check} as an external command, and parses its output and
returns the check failures.
}
\details{
See \link{rcmdcheck_process} if you need to run \verb{R CMD check} in a background
process.
}
\section{Turning off package checks}{
Sometimes it is useful to programmatically turn off some checks that
may report check NOTEs.
rcmdcehck provides two ways to do this.

First, you may declare in \code{DESCRIPTION} that you don't want to see
NOTEs that are accepted on CRAN, with this entry:\preformatted{Config/rcmdcheck/ignore-inconsequential-notes: true
}

Currently, this will make rcmdcheck ignore the following notes:
\itemize{
\item report large package sizes (\verb{_R_CHECK_PKG_SIZES_ = FALSE}),
\item check cross-references in Rd files (\verb{_R_CHECK_RD_XREFS_ = FALSE}),
\item NOTE if package requires GNU make (\verb{_R_CHECK_CRAN_INCOMING_NOTE_GNU_MAKE_ = FALSE}),
\item report marked non-ASCII strings in datasets (\verb{_R_CHECK_PACKAGE_DATASETS_SUPPRESS_NOTES_ = TRUE}).
}

The second way is more flexible, and lets you turn off individual checks
via setting environment variables.
You may provide a \code{tools/check.env} \emph{environment file} in your package
with the list of environment variable settings that rcmdcheck will
automatically use when checking the package.
See \link{Startup} for the format of this file.

Here is an example \code{tools/check.env} file:\preformatted{# Report if package size is larger than 10 megabytes
_R_CHECK_PKG_SIZES_THRESHOLD_=10

# Do not check Rd cross references
_R_CHECK_RD_XREFS_=false

# Do not report if package requires GNU make
_R_CHECK_CRAN_INCOMING_NOTE_GNU_MAKE_=false

# Do not check non-ASCII strings in datasets
_R_CHECK_PACKAGE_DATASETS_SUPPRESS_NOTES_=true
}

See the \href{https://cran.r-project.org/doc/manuals/r-devel/R-ints.html}{"R internals" manual}
and the \href{https://github.com/wch/r-source}{R source code} for the
environment variables that control the checks.

Note that \code{Config/rcmdcheck/ignore-inconsequential-notes} and the
\code{check.env} file are only supported by rcmdcheck, and running
\verb{R CMD check} from a shell (or GUI) will not use them.
}

