% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{package}
\name{Atoms}
\alias{Atoms}
\title{Operations on Atoms}
\description{
\code{\link{get.symbol}} returns the chemical symbol for an atom
\code{\link{get.point3d}} returns the 3D coordinates of the atom
\code{\link{get.point2d}} returns the 2D coordinates of the atom
\code{\link{get.atomic.number}} returns the atomic number of the atom
\code{\link{get.hydrogen.count}}  returns the number of implicit H’s on the atom. 
          Depending on where the molecule was read from this may be \code{NULL}
          or an integer greater than or equal to \code{0}
\code{\link{get.charge}} returns the partial charge on the atom. If charges 
          have not been set the return value is \code{NULL}, otherwise 
          the appropriate charge.
\code{\link{get.formal.charge}} returns the formal charge on the atom. By 
           default the formal charge will be \code{0} (i.e., \code{NULL}
           is never returned)
\code{\link{is.aromatic}} returns \code{TRUE} if the atom is aromatic,
           \code{FALSE} otherwise
\code{\link{is.aliphatic}} returns \code{TRUE} if the atom is part of an 
           aliphatic chain, \code{FALSE} otherwise
\code{\link{is.in.ring}} returns \code{TRUE} if the atom is in a ring, 
            \code{FALSE} otherwise
\code{\link{get.atom.index}} eturns the index of the atom in the molecule
            (starting from \code{0})
\code{\link{get.connected.atoms}} returns a list of atoms that are connected to the specified atom
}
\section{Usage}{

get.symbol(atom)
get.point3d(atom)
get.point2d(atom)
get.atomic.number(atom)
get.hydrogen.count(atom)
get.charge(atom)
get.formal.charge(atom)
get.connected.atoms(atom, mol)
get.atom.index(atom, mol)
is.aromatic(atom)
is.aliphatic(atom)
is.in.ring(atom) 
set.atom.types(mol)
}

\section{Arguments}{

 atom A jobjRef representing an IAtom object
 mol  A jobjRef representing an IAtomContainer object
}

\section{Value}{

 In the case of \code{\link{get.point3d}} the return value is a 3-element vector 
 containing the X, Y and Z co-ordinates of the atom.  If the atom does not 
 have 3D coordinates, it returns a vector of the form \code{c(NA,NA,NA)}.
 Similarly for \code{\link{get.point2d}}, in which case the return vector is of 
 length \code{2}.
}

\author{
Rajarshi Guha (\email{rajarshi.guha@gmail.com})
}
