message("TESTING: abort()...")

library("R.oo")

foo <- function() {
  cat("foo()...\n")
  on.exit(cat("foo()...done\n"))
  tryCatch({
    stop("Woops!")
  }, error = function(ex) {
    cat("An error was caught: ", ex$message, "\n", sep="")
  })
  cat("Continuing...\n")
}

bar <- function() {
  cat("bar()...\n")
  on.exit(cat("bar()...done\n"))
  tryCatch({
    abort("Woops!")
  }, error = function(ex) {
    cat("An error was caught: ", ex$message, "\n", sep="")
  })
  cat("This message will never be displayed...\n")
}

# An error generated by stop() can be caught
foo()

## abort() will abort covr::package_coverage() and
## and any other evaluations beyond this point.
if (!"covr" %in% loadedNamespaces() && FALSE) {
# ...which is not possible when using abort()
bar()

# This expression is never reached
cat("This line will never be outputted.\n")
} #

message("TESTING: abort()...DONE")
