% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-combine.R
\name{list_c}
\alias{list_c}
\alias{list_cbind}
\alias{list_rbind}
\title{Combine list elements into a single data structure}
\usage{
list_c(x, ..., ptype = NULL)

list_cbind(
  x,
  ...,
  name_repair = c("unique", "universal", "check_unique"),
  size = NULL
)

list_rbind(x, ..., names_to = rlang::zap(), ptype = NULL)
}
\arguments{
\item{x}{A list. For \code{list_rbind()} and \code{list_cbind()} the list must
only contain only data frames or \code{NULL}.}

\item{...}{These dots are for future extensions and must be empty.}

\item{ptype}{An optional prototype to ensure that the output type is always
the same.}

\item{name_repair}{One of \code{"unique"}, \code{"universal"}, or \code{"check_unique"}.
See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}} for the meaning of these options.}

\item{size}{An optional integer size to ensure that every input has the
same size (i.e. number of rows).}

\item{names_to}{By default, \code{names(x)} are lost. To keep them, supply a
string to \code{names_to} and the names will be saved into a column with that
name. If \code{names_to} is supplied and \code{x} is not named, the position of
the elements will be used instead of the names.}
}
\description{
\itemize{
\item \code{list_c()} combines elements into a vector by concatenating them together
with \code{\link[vctrs:vec_c]{vctrs::vec_c()}}.
\item \code{list_rbind()} combines elements into a data frame by row-binding them
together with \code{\link[vctrs:vec_bind]{vctrs::vec_rbind()}}.
\item \code{list_cbind()} combines elements into a data frame by column-binding them
together with \code{\link[vctrs:vec_bind]{vctrs::vec_cbind()}}.
}
}
\examples{
x1 <- list(a = 1, b = 2, c = 3)
list_c(x1)

x2 <- list(
  a = data.frame(x = 1:2),
  b = data.frame(y = "a")
)
list_rbind(x2)
list_rbind(x2, names_to = "id")
list_rbind(unname(x2), names_to = "id")

list_cbind(x2)
}
