% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strip.terms.R
\name{strip.terms}
\alias{strip.terms}
\title{Strip special functions from terms}
\usage{
strip.terms(terms, specials, alias.names = NULL, unspecials = NULL,
  arguments, keep.response = TRUE)
}
\arguments{
\item{terms}{Terms object}

\item{specials}{Character vector of specials which should be
stripped off}

\item{alias.names}{Optional. A named list with alias names for the specials.}

\item{unspecials}{Optional. A special name for treating all the unspecial terms.}

\item{arguments}{A named list of arguments, one for each element
of specials. Elements are passed to \code{parseSpecialNames}.}

\item{keep.response}{Keep the response in the resulting object?}
}
\value{
Reformulated terms object with an additional attribute which contains the \code{stripped.specials}.
}
\description{
Reformulate a terms object such that some specials are stripped off
}
\details{
This function is used to remove special specials, i.e., those
which cannot or should not be evaluated. 
IMPORTANT: the unstripped terms need to know about all specials including the aliases.
See examples.
}
\examples{

## parse a survival formula and identify terms which
## should be treated as proportional or timevarying:
f <- Surv(time,status)~age+prop(factor(edema))+timevar(sex,test=0)+prop(bili,power=1)
tt <- terms(f,specials=c("prop","timevar"))
attr(tt,"specials")
st <- strip.terms(tt,specials=c("prop","timevar"),arguments=NULL)
formula(st)
attr(st,"specials")
attr(st,"stripped.specials")

## provide a default value for argument power of proportional treatment
## and argument test of timevarying treatment: 
st2 <- strip.terms(tt,
                   specials=c("prop","timevar"),
                   arguments=list("prop"=list("power"=0),"timevar"=list("test"=0)))
formula(st2)
attr(st2,"stripped.specials")
attr(st2,"stripped.arguments")

## treat all unspecial terms as proportional
st3 <- strip.terms(tt,
                   unspecials="prop",
                   specials=c("prop","timevar"),
                   arguments=list("prop"=list("power"=0),"timevar"=list("test"=0)))
formula(st3)
attr(st3,"stripped.specials")
attr(st3,"stripped.arguments")

## allow alias names: strata for timevar and tp, const for prop.
## IMPORTANT: the unstripped terms need to know about
## all specials including the aliases
f <- Surv(time,status)~age+const(factor(edema))+strata(sex,test=0)+prop(bili,power=1)+tp(albumin)
tt2 <- terms(f,specials=c("prop","timevar","strata","tp","const"))
st4 <- strip.terms(tt2,
                   specials=c("prop","timevar"),
                   unspecials="prop",
                   alias.names=list("timevar"="strata","prop"=c("const","tp")),
                   arguments=list("prop"=list("power"=0),"timevar"=list("test"=0)))
formula(st4)
attr(st4,"stripped.specials")
attr(st4,"stripped.arguments")

## test if alias works also without unspecial argument
st5 <- strip.terms(tt2,
                   specials=c("prop","timevar"),
                   alias.names=list("timevar"="strata","prop"=c("const","tp")),
                   arguments=list("prop"=list("power"=0),"timevar"=list("test"=0)))
formula(st5)
attr(st5,"stripped.specials")
attr(st5,"stripped.arguments")

library(survival)
data(pbc)
model.design(st4,data=pbc[1:3,],specialsDesign=TRUE)
model.design(st5,data=pbc[1:3,],specialsDesign=TRUE)


}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
\seealso{
parseSpecialNames reformulate drop.terms
}

