% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_chains.R
\name{merge_chains}
\alias{merge_chains}
\alias{merge_chains.draws_matrix}
\alias{merge_chains.draws_array}
\alias{merge_chains.draws_df}
\alias{merge_chains.draws_list}
\alias{merge_chains.rvar}
\alias{merge_chains.draws_rvars}
\title{Merge chains of \code{draws} objects}
\usage{
merge_chains(x, ...)

\method{merge_chains}{draws_matrix}(x, ...)

\method{merge_chains}{draws_array}(x, ...)

\method{merge_chains}{draws_df}(x, ...)

\method{merge_chains}{draws_list}(x, ...)

\method{merge_chains}{rvar}(x, ...)

\method{merge_chains}{draws_rvars}(x, ...)
}
\arguments{
\item{x}{(draws) A \code{draws} object or another \R object for which the method
is defined.}

\item{...}{Arguments passed to individual methods (if applicable).}
}
\value{
A \code{draws} object of the same class as \code{x}.
}
\description{
Merge chains of \code{\link{draws}} objects into a single chain. Some operations will
trigger an automatic merging of chains, for example, because chains do not
match between two objects involved in a binary operation. By default, no
warning will be issued when this happens but you can activate one via
\code{options(posterior.warn_on_merge_chains = TRUE)}.
}
\examples{
x <- example_draws()

# draws_array with 4 chains, 100 iters each
str(x)

# draws_array with 1 chain of 400 iterations
str(merge_chains(x))

}
