% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-summaries.R
\name{dissent}
\alias{dissent}
\alias{dissent.default}
\alias{dissent.rvar}
\title{Dissention}
\usage{
dissent(x)

\method{dissent}{default}(x)

\method{dissent}{rvar}(x)
}
\arguments{
\item{x}{(multiple options) A vector to be interpreted as draws from
an ordinal distribution, such as:
\itemize{
\item A \link{factor}
\item A \link{numeric} (should be \link{integer} or integer-like)
\item An \link{rvar}, \link{rvar_factor}, or \link{rvar_ordered}
}}
}
\value{
If \code{x} is a \link{factor} or \link{numeric}, returns a length-1 numeric vector with a value
between 0 and 1 (inclusive) giving the dissention of \code{x}.

If \code{x} is an \link{rvar}, returns an array of the same shape as \code{x}, where each
cell is the dissention of the draws in the corresponding cell of \code{x}.
}
\description{
Dissention, for measuring dispersion in draws from ordinal distributions.
}
\details{
Calculates Tastle and Wierman's (2007) \emph{dissention} measure:

\deqn{-\sum_{i = 1}^{n} p_i \log_2 \left(1 - \frac{|x_i - \mathrm{E}(x)| }{\max(x) - \min(x)} \right)}

This ranges from 0 (all probability in one category) through 0.5 (uniform) to
1 (bimodal: all probability split equally between the first and last category).
}
\examples{
set.seed(1234)

levels <- c("lowest", "low", "neutral", "high", "highest")

# a bimodal distribution: high dissention
x <- ordered(
  sample(levels, 4000, replace = TRUE, prob = c(0.45, 0.04, 0.02, 0.04, 0.45)),
  levels = levels
)
dissent(x)

# a unimodal distribution: low dissention
y <- ordered(
  sample(levels, 4000, replace = TRUE, prob = c(0.95, 0.02, 0.015, 0.01, 0.005)),
  levels = levels
)
dissent(y)

# both together, as an rvar
xy <- c(rvar(x), rvar(y))
xy
dissent(xy)
}
\references{
William J. Tastle, Mark J. Wierman (2007). Consensus and dissention: A measure
of ordinal dispersion. \emph{International Journal of Approximate Reasoning}.
45(3), 531--545.
\doi{10.1016/j.ijar.2006.06.024}.
}
